@extends('redesign.layouts.dashboard')

@section('title', $title)

@section('documentTitle', $title)

@section('overlay-style', 'display:block')

@section('scripts-page')
    <script src="{{ asset('js/plugins/bootstrap/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ asset('js/plugins/bootstrap/bootstrap-datepicker.de.min.js') }}"></script>
    <script src="{{ asset('js/plugins/nouislider/nouislider.min.js') }}"></script>
    <script src="{{ asset('js/plugins/bootstrap/jquery.bootstrap-touchspin.min.js') }}"></script>
    <script src="{{ asset('js/plugins/cleave/cleave.min.js') }}"></script>
    <script src="{{ asset('js/plugins/mask/jquery.mask.js') }}"></script>
    <script src="{{ asset('js/plugins/mark/jquery.mark.min.js') }}"></script>
    <script src="{{ asset('js/plugins/masonry/masonry.pkgd.min.js') }}"></script>
    <script src="{{ asset('js/plugins/noty/noty.min.js') }}"></script>
    <script src="{{ asset('js/plugins/jquery-ui/sortable/jquery-ui.min.js') }}"></script>
    <script src="{{ asset('js/plugins/slick/slick.min.js') }}"></script>
    <script src="{{ asset('js/plugins/jqueryfileupload/vendor/jquery.ui.widget.js') }}"></script>
    <script src="{{ asset('js/plugins/jqueryfileupload/jquery.iframe-transport.js') }}"></script>
    <script src="{{ asset('js/plugins/jqueryfileupload/jquery.fileupload.js') }}"></script>
    <script src="{{ asset('js/plugins/jqueryfileupload/jquery.fileupload-process.js') }}"></script>
    <script src="{{ asset('js/plugins/jqueryfileupload/jquery.fileupload-validate.js') }}"></script>
    <script src="{{ asset('js/deal_constructor.js') }}"></script>
    <script>
        var dealId = {{ $deal->id }};
    </script>

    @if (0)
    <script>
        var dealId = {{ $deal->id }};
        var markerCoords = {
            lat: {{ $deal->lat ?? Auth::user()->account->lat ?? 52.519005703808844 }},
            lon: {{ $deal->lon ?? Auth::user()->account->lon ?? 13.405599509814465 }},
        };
    </script>
    <script src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google_maps.key') }}&libraries=places&callback=mapInit"></script>
    @endif
@endsection

@section('document')
    <div class="container" id="dashboardContentHolder">
        <div id="dcLeft">
            <div id="dcLeftInner">
                @include('redesign.back.seller.deal.pieces.constructor.menu')
                @include('redesign.back.seller.deal.pieces.constructor.actions')
            </div>
        </div>
        <div id="dcRight">
            <div id="rightInner">
                @include('redesign.back.seller.deal.pieces.constructor.steps.step_general')
                @include('redesign.back.seller.deal.pieces.constructor.steps.step_category')
                @include('redesign.back.seller.deal.pieces.constructor.steps.step_cashback')
                @include('redesign.back.seller.deal.pieces.constructor.steps.step_premium')
                @include('redesign.back.seller.deal.pieces.constructor.steps.step_place')
                @include('redesign.back.seller.deal.pieces.constructor.steps.step_gallery')
                <div class="col-12">
                    <div class="alert alert-info">
                        <span class="star">*</span> Pflichtangabe
                    </div>
                </div>
                @include('redesign.back.seller.deal.pieces.constructor.actions_bottom')
            </div>
        </div>
    </div>
    @include('redesign.back.seller.deal.pieces.constructor.image_preview')
    @include('redesign.back.seller.deal.pieces.constructor.deal_preview')
@endsection