@if ($reviewsCount)
    <div class="dashboardMainMenuItem">
        <a href="{{ route('seller.reviews.index') }}">
            <div class="flip-container">
                <div class="flipper">
                    <div class="flipper-front shadow">
                        <div class="dashboardMainMenuItemBody">
                            <div class="dashboardMainMenuItemIcon">
                                <i class="fas fa-star"></i>
                            </div>
                        </div>
                        <div class="dashboardMainMenuItemTitle">Bewertungen</div>
                    </div>
                    <div class="flipper-back shadow">
                        <div class="text-center mt-4">
                            @include('redesign.front.pieces.rating', ['rating' => $reviewsAvg])
                            <span id="sellerRatingAvg">{{ $reviewsAvg }}</span> <span id="sellerRatingCount">/ {{ $reviewsCount }}</span>
                        </div>
                        <div class="mt-3 text-center">
                            @foreach($reviewsCounts as $k => $v)
                                <div>
                                    <div class="sellerRatingMarkCount">{{ $v }}</div>
                                    @include('redesign.front.pieces.rating', ['rating' => $k, 'classes' => 'dashboard'])
                                </div>
                            @endforeach
                        </div>
                        <div class="dashboardMainMenuItemTitle">Bewertungen</div>
                    </div>
                </div>
            </div>
        </a>
    </div>
@else
    <div class="dashboardMainMenuItem bg-white shadow">
        <a href="{{ route('seller.reviews.index') }}">
            <div class="dashboardMainMenuItemBody">
                <div class="dashboardMainMenuItemIcon">
                    <i class="fas fa-star"></i>
                </div>
            </div>
            <div class="dashboardMainMenuItemTitle">Bewertungen</div>
        </a>
    </div>
@endif