@extends('redesign.layouts.dashboard')

@section('title', 'Seller Dashboard')

@section('documentTitle', 'Seller Dashboard')

@if(0)
    @section('body-attributes', 'data-tour="seller-dashboard-index"')
@endif

@section('document')
    <div class="container" id="dashboardContentHolder">
        @if(!$user->email_verified)
            <div class="alert alert-warning text-center">
                <p>Bitte bestätige Deine E-Mail. Wir haben eine Bestätigungsmail mit einem Link an <strong>{{ $user->email_temp ? $user->email_temp : $user->email }}</strong> gesendet.</p>
                <p>Sollte die E-Mail nicht angekommen sein bitte <a href="#" class="alert-link" id="emailVerificationSend">hier klicken</a>.</p>
            </div>
        @endif

        <div id="dashboardMainMenuHolder" class="d-flex justify-content-around justify-content-xl-between flex-wrap">
            @include('redesign.back.seller.dashboard.pieces.profile_btn')
            @include('redesign.back.seller.dashboard.pieces.new_deal_btn')
            @include('redesign.back.seller.dashboard.pieces.share_btn')
            @include('redesign.back.seller.dashboard.pieces.redeeming_btn')
            @include('redesign.back.seller.dashboard.pieces.deals_btn')
            @include('redesign.back.seller.dashboard.pieces.coupons_btn')
            @include('redesign.back.seller.dashboard.pieces.transactions_btn')
            @include('redesign.back.seller.dashboard.pieces.preview_btn')

            <div class="dashboardMainMenuItemEmpty"></div>
            <div class="dashboardMainMenuItemEmpty"></div>
            <div class="dashboardMainMenuItemEmpty"></div>
        </div>
    </div>
@endsection