@extends('redesign.layouts.dashboard')

@section('title', 'Empfohlene BONS')

@section('documentTitle', 'Empfohlene BONS')

@section('overlay-style', 'display:block')

@section('document')
    <div class="container" id="dashboardContentHolder">
        @if( $coupons->count() )
            <div class="row mb-4">
                <div class="col-12">
                    <a class="btn btn-primary" href="{{ route('seller.coupon.redeeming.index') }}">
                        <i class="fas fa-barcode"></i> RECO.BON einlösen
                    </a>
                </div>
            </div>

            <div class="row mb-4">
                <div class="form-group col-12 inputHolder">
                    <label for="couponSearchInput">RECO.BON suche</label>
                    <div class="input-group">
                        <input type="search" class="form-control" id="couponSearchInput" placeholder="Beginne zu suchen">
                        <div class="input-group-append">
                            <button class="btn btn-outline-secondary" type="button" id="couponSearchReset">
                                <i class="fas fa-ban"></i> Zurücksetzen
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row d-none" id="sellerCouponsTableHolder">
                @include('redesign.back.seller.coupons.pieces.table')
            </div>
        @else
            <div class="pt-5 pb-5 text-center">
                <h2 class="mb-4">Noch keine empfohlenen BONS.</h2>
                <a class="btn btn-primary" href="{{ route('home') }}">
                    <i class="fas fa-tachometer-alt"></i> Zum Dashboard
                </a>
            </div>

            <div class="row" id="sellerCouponsTableHolder">
                @include('redesign.back.seller.coupons.pieces.table_fake')
            </div>
        @endif
    </div>
@endsection

@section('scripts-page')
    <script src="{{ asset('js/plugins/dataTables/datatables.min.js') }}"></script>
    <script src="{{ asset('js/plugins/dataTables/dataTables.bootstrap4.min.js') }}"></script>
    <link rel="stylesheet" href="{{ asset('css/plugins/dataTables/dataTables.bootstrap4.css') }}">

    @if( $coupons->count() )

        <script>
            $(document).ready(function() {
                var dt = $('#sellerCouponsTable').DataTable({
                    order: [],
                    autoWidth: false,
                    dom: '<"col-12"<"row"<"col-12 col-sm-6 col-lg-3 col-xl-4 text-center text-sm-left"l><"col-12 col-sm-6 col-lg-3 col-xl-4 text-center text-sm-right text-lg-center"i><"col-12 col-lg-6 col-xl-4 text-right"p>>>' +
                        '<"col-12"t>' +
                        '<"col-12"<"row"<"col-12 col-sm-6 col-lg-3 col-xl-4 text-center text-sm-left"l><"col-12 col-sm-6 col-lg-3 col-xl-4 text-center text-sm-right text-lg-center"i><"col-12 col-lg-6 col-xl-4 text-right"p>>>',
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, 'Alle']],
                    language: {
                        url: '{{ asset('js/plugins/dataTables/i18n/German.json') }}',
                    }
                });

                $('#couponSearchInput').on('change keyup', function () {
                    var s = $(this).val().trim();
                    s = s.replace(/\s/g, '');
                    dt.search(s).draw();
                });

                $('#couponSearchReset').on('click', function () {
                    $('#couponSearchInput').val('').change();
                });

                $('#sellerCouponsTableHolder').removeClass('d-none');
                $('#overlay').hide();

                var setCuponPaid = function (couponId) {
                    $('#overlay').show();
                    fetch('/api/coupon/' + couponId + '/paid/', {
                        headers: {
                            'Accept': 'application/json',
                        },
                        method: 'POST',
                    }).then(response => {
                        if (response.ok) {
                            location.reload();
                        }
                        if (401 === response.status || 422 === response.status) {
                            return response.json().then(err => {throw err;});
                        }
                    }).catch(error => {
                        $('#overlay').hide();
                        var e = _processAPIError(error).join('<br>');
                        swal(e, '', 'error');
                    });
                };

                $(document).on('click', '.sellerSetCouponPaid', function (e) {
                    e.preventDefault();

                    var couponId = $(this).data('coupon-id');

                    swal({
                        title: 'Bist du sicher?',
                        heightAuto: false,
                        text: 'Sie können das nicht rückgängig machen!',
                        type: 'warning',
                        showCancelButton: true,
                    }).then((result) => {
                        if (result.value) {
                            setCuponPaid(couponId);
                        }
                    });
                });
            });
        </script>

    @else

        <script>
            $(document).ready(function() {
                var dt = $('#sellerCouponsTable').DataTable({
                    paging: false,
                    info: false,
                    searching: false,
                    autoWidth: false,
                    dom: 't',
                    order: [[ 0, 'asc' ]],
                    language: {
                        url: '{{ asset('js/plugins/dataTables/i18n/German.json') }}',
                    }
                });
                $('#overlay').hide();
            });
        </script>

    @endif
@endsection