@extends('redesign.layouts.dashboard')

@section('title', 'RECO.BON einlösen')

@section('documentTitle', 'RECO.BON einlösen')

@section('scripts-page')
    <script src="{{ asset('js/plugins/cleave/cleave.min.js') }}"></script>
    <script src="{{ asset('js/plugins/mask/jquery.mask.js') }}"></script>
    <script src="{{ asset('js/redeeming.js') }}"></script>
@endsection

@section('document')
    <div class="container">
        <div class="">
            <div class="" id="dashboardInner">
                @if( !$user->hasPaymentType() )
                    <div class="alert alert-danger text-center">
                        Du hast keine Zahlungsdaten. <a class="alert-link" href="{{ route('seller.profile.index') . '#payment' }}">Jetzt einstellen</a>
                    </div>
                @endif

                @if( !$user->email_verified )
                    <div class="alert alert-danger text-center">
                        <p>Bitte bestätige Deine E-Mail. Wir haben eine Bestätigungsmail mit einem Link an <strong>{{ $user->email_temp ? $user->email_temp : $user->email }}</strong> gesendet.</p>
                        <p>Sollte die E-Mail nicht angekommen sein bitte <a href="#" class="alert-link" id="emailVerificationSend">hier klicken</a>.</p>
                    </div>
                @endif

                <form id="redeemingForm" @if( !$user->hasPaymentType() || !$user->email_verified ) style="opacity: 0.5" @endif>
                    @if( !$user->hasPaymentType() || !$user->email_verified )
                        <div id="redeemingFormOverlay"></div>
                    @endif

                    <div class="text-center">
                        <h2 class="mb-5">RECO.BON einlösen</h2>
                    </div>

                    <div class="text-center">
                        <img id="redeemingSellerLogo" src="{{ Auth::user()->account->logo }}" />
                    </div>
                    <div id="redeemingStepsHolder" class="pt-5">
                        <div class="redeemingStep" id="redeemingStepCode">
                            <div class="form-group text-center" id="redeemingCodeInputHolder">
                                <input id="redeemingCode" class="form-control" type="text" placeholder="# RECO.CODE eingeben" value="{{ $code }}" @if( !$user->hasPaymentType() || !$user->email_verified ) disabled @endif>
                                <div id="redeemingCodeInputBtn"><i class="fas fa-arrow-right"></i></div>
                            </div>
                            <div class="form-group text-center">
                                <div class="btn btn-primary btn-half-width" id="redeemingCodeBtn">
                                    Weiter <i class="fas fa-arrow-right"></i>
                                </div>
                            </div>
                        </div>

                        <div class="redeemingStep" id="redeemingStepNetto">
                            <div class="form-group text-center" id="redeemingNettoInputHolder">
                                <div id="redeemingNettoEuro">&euro;</div>
                                <input type="text" class="form-control input-euro" id="redeemingNetto" placeholder="Warenwert" autocomplete="off">
                                <div id="redeemingNettoInputBtn"><i class="fas fa-arrow-right"></i></div>
                            </div>
                            <div class="form-group text-center">
                                <div class="btn btn-secondary btn-half-width" id="redeemingNettoBackBtn">
                                    <i class="fas fa-arrow-left"></i> Zurück
                                </div>
                                <div class="btn btn-primary btn-half-width" id="redeemingNettoBtn">
                                    Weiter <i class="fas fa-arrow-right"></i>
                                </div>
                            </div>
                        </div>

                        <div class="redeemingStep" id="redeemingStepPayment">
                            <div class="form-group text-center" style="padding:7px 0;">
                                <div class="custom-control custom-radio custom-control-inline">
                                    <input type="radio" id="redeemingPaymentCash" name="payment_type" value="cash" class="custom-control-input" checked>
                                    <label class="custom-control-label" for="redeemingPaymentCash">Barkauf</label>
                                </div>
                                <div class="custom-control custom-radio custom-control-inline">
                                    <input type="radio" id="redeemingPaymentAccount" name="payment_type" value="account" class="custom-control-input">
                                    <label class="custom-control-label" for="redeemingPaymentAccount">Rechnung</label>
                                </div>
                            </div>
                            <div class="form-group text-center">
                                <div class="btn btn-secondary btn-half-width" id="redeemingPaymentBackBtn">
                                    <i class="fas fa-arrow-left"></i> Zurück
                                </div>
                                <div class="btn btn-primary btn-half-width" id="redeemingFinishBtn">
                                    Beenden <i class="fas fa-arrow-right"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <a class="d-none" id="redeemingCancelBtn" href="{{ ( url()->previous() !== url()->current() ) ? url()->previous() : route('home') }}">Abbrechen</a>
                </form>
            </div>
        </div>
    </div>
@endsection