<div class="kt-portlet kt-portlet--mobile">
    <div class="kt-portlet__head kt-portlet__head--lg">
        <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon">
                    <i class="fas fa-code"></i>
                </span>
            <h3 class="kt-portlet__head-title">
                Empfehlung Widget
            </h3>
        </div>
    </div>

    <div class="kt-portlet__body">
        @include('redesign.back.metronic.pieces.alert', [
            'type' => 'info',
            'heading' => 'Hinweis',
            'text' => 'Wähle Du eine Deiner Kampagnen aus um noch mehr Reichweite zu generieren indem Dich ein Widget auf Deiner Seite platzieren. Diese Widget wird auf jeder Seite Deiner Homepage platziert. Besucher können Dein Unternehmen und das Produkt direkt aus diesem Widget heraus empfehlen. Dazu muss nur dieses Script in den bestehenden Code Deiner Seite eingebettet werden. Gerne helfen wir bei der Umsetzung. Sprich Du uns gerne an.',
        ])

        <div class="alert alert-secondary">
            <div class="alert-text">
                <h4 class="alert-heading mb-4">Widget Kampagne</h4>
                @if( $user->canDo('edit widgets', true) )
                    <form class="form-horizontal" action="{{ route('save-invite-widget-options', ['user' => $seller]) }}" method="post">
                        {{ csrf_field() }}
                        <div class="form-group @if ($errors->has('deal')) validated @endif">
                            <div class="kt-radio-list">
                                @foreach($deals as $deal)
                                    <label class="kt-radio kt-radio--solid kt-radio--brand">
                                        <input type="radio" id="deal_{{ $deal->id }}" name="deal" class="custom-control-input" value="{{ $deal->id }}" @if( isset($options['invite.deal_id']) && $deal->id === (int)$options['invite.deal_id']->value ) checked @endif>
                                        {{ $deal->title }} (<strong>{{ $deal->present()->provisionAgent }}</strong> Provision für Empfehlung, <strong>{{ $deal->present()->discountConsumer }}</strong> Cashback für Einkauf)
                                        <span></span>
                                    </label>
                                @endforeach

                                <div class="invalid-feedback">{{ $errors->first('deal') }}</div>
                            </div>
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Speichern
                            </button>
                        </div>
                    </form>
                @else
                    <p>
                        @foreach($deals as $deal)
                            @if( isset($options['invite.deal_id']) && $deal->id === (int)$options['invite.deal_id']->value )
                                {{ $deal->title }} (<strong>{{ $deal->present()->provisionAgent }}</strong> Provision für Empfehlung, <strong>{{ $deal->present()->discountConsumer }}</strong> Cashback für Einkauf)
                            @endif
                        @endforeach
                    </p>
                @endif
            </div>
        </div>

        <div class="alert alert-success" role="alert">
            <div class="alert-text">
                <h4 class="alert-heading">Code</h4>
                <span id="widgetInviteCode">{{ $widgetInviteCode }}</span>
                <div class="btn btn-primary btn-sm btn-icon btn-circle clipboard" id="widgetInviteCodeCopy" data-clipboard-target="#widgetInviteCode" data-title="in die Zwischenablage kopieren" data-toggle="kt-tooltip">
                    <i class="far fa-copy"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="kt-portlet__foot">
        <div class="row align-items-center">
            <div class="col-lg-12">
                <a class="btn btn-primary" href="{{ route('seller.widgets.preview.invite') }}" target="_blank">
                    <i class="fas fa-eye"></i> Vorschau
                </a>
            </div>
        </div>
    </div>
</div>