@extends('redesign.layouts.metronic.dashboard')

@section('title', 'Widgets')

@section('documentTitle', 'Widgets')

@section('document')
    @if( !$deals->count() )
        <div class="alert alert-warning">
            <div class="alert-icon"><i class="fas fa-exclamation-triangle"></i></div>
            <div class="alert-text">
                Widgets können erst funktionieren, wenn Du keine aktiven Kampagnen hast.
                <a class="alert-link" href="{{ route('seller.deal.create') }}">
                    <i class="fas fa-plus-circle"></i> Neue Kampagne erstellen
                </a>
            </div>
        </div>
    @endif

    @include('redesign.back.metronic.widgets.pieces.colors')

    @include('redesign.back.metronic.widgets.pieces.invite_widget')

    @include('redesign.back.metronic.widgets.pieces.deals_widget')
@endsection

@section('scripts-page')
    <script>
        $(document).ready(function () {
            $('input[type="color"]').on('change', function () {
                var id = '#' + $(this).attr('id');
                $('input[data-helpto="' + id + '"]').val($(this).val());
            });

            $('input[data-helpto]').on('keyup change', function () {
                var id = $(this).data('helpto');
                $(id).val($(this).val());
            });
        });
    </script>
@endsection