<div class="modal" tabindex="-1" role="dialog" id="t{{ $transaction->first()->id }}">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ $transaction->first()->coupon->present()->code  }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table table-striped table-borderless">
                    <thead>
                    </thead>
                    <tbody>
                    <tr>
                        <td>RECO.BON</td>
                        <td><span class="text-monospace">{{ $transaction->first()->coupon->present()->code }}</span></td>
                    </tr>
                    <tr>
                        <td>Kunde</td>
                        <td>
                            @include('redesign.back.metronic.pieces.user_card', [
                                'img' => $transaction->first()->coupon->consumer->userpic,
                                'title' => $transaction->first()->coupon->consumer->fullname,
                            ])
                        </td>
                    </tr>
                    <tr>
                        <td>Empfehler</td>
                        <td>
                            @include('redesign.back.metronic.pieces.user_card', [
                                'img' => $transaction->first()->coupon->agent->userpic,
                                'title' => $transaction->first()->coupon->agent->fullname,
                            ])
                        </td>
                    </tr>
                    <tr>
                        <td>Gebühr</td>
                        <td>{{ $transaction->where('type', App\Transaction::TYPE_SELLER_OPERATOR_PROVISION_PAYMENT)->first()->present()->amount }}</td>
                    </tr>
                    <tr>
                        <td>Cashback</td>
                        <td>{{ $transaction->where('type', App\Transaction::TYPE_SELLER_CONSUMER_DISCOUNT_PAYMENT)->first()->present()->amount }}</td>
                    </tr>
                    <tr>
                        <td>RECO.CASH</td>
                        <td>{{ $transaction->where('type', App\Transaction::TYPE_SELLER_AGENT_PROVISION_PAYMENT)->first()->present()->amount }}</td>
                    </tr>
                    <tr>
                        <td>Status</td>
                        <td>
                            @if (App\Transaction::STATUS_ALLOCATED === $transaction->first()->status && App\Coupon::STATUS_PAID === $transaction->first()->coupon->status)
                                <span class="kt-badge kt-badge--warning kt-badge--inline kt-badge--pill">Einziehbar</span>
                            @elseif (App\Transaction::STATUS_ALLOCATED === $transaction->first()->status && App\Coupon::STATUS_DONE === $transaction->first()->coupon->status)
                                <span class="kt-badge kt-badge--primary kt-badge--inline kt-badge--pill">Im Banklauf</span>
                            @else
                                {{ $transaction->first()->present()->status_metronic }}
                            @endif
                        </td>
                    </tr>
                    @if ($transaction->first()->invoice_id)
                        <tr>
                            <td colspan="2" class="text-center">
                                <a class="btn btn-primary" href="{{ $transaction->first()->getPDFLink() }}" target="_blank">
                                    <i class="far fa-file-pdf"></i> Beleg
                                </a>
                            </td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Schließen</button>
            </div>
        </div>
    </div>
</div>