@extends('redesign.layouts.metronic.dashboard')

@section('title', 'Konto')

@section('documentTitle', 'Konto')

@section('overlay-style', 'display:block')

@section('styles-page')
    <link href="{{ asset('metronic/vendors/custom/datatables/datatables.bundle.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('document')
    @if( $transactions->count() )
        @include('redesign.back.metronic.transactions.pieces.numbers')
    @endif

    <div class="kt-portlet kt-portlet--mobile">
        <div class="kt-portlet__head kt-portlet__head--lg">
            <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon">
                    <i class="fas fa-piggy-bank"></i>
                </span>
                <h3 class="kt-portlet__head-title">
                    Konto
                </h3>
            </div>
        </div>

        <div class="kt-portlet__body">
            @if( $transactions->count() )
                <div class="mb-4">
                    <div class="form-group col-12 inputHolder">
                        <label for="transactionsSearchInput">Suche</label>
                        <div class="input-group">
                            <input type="search" class="form-control" id="transactionsSearchInput" placeholder="Beginne zu suchen">
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary" type="button" id="transactionsSearchReset">
                                    <i class="fas fa-ban"></i> Zurücksetzen
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="sellerTransactionsTableHolder" class="d-none">
                    @include('redesign.back.metronic.transactions.pieces.table')
                </div>
            @else
                <div class="pt-5 pb-5 text-center">
                    <h2 class="mb-4">Es liegen noch keine Transaktionen vor.</h2>
                    <a class="btn btn-primary" href="{{ route('home') }}">
                        <i class="fas fa-tachometer-alt"></i> Zum Dashboard
                    </a>
                </div>

                <div id="sellerTransactionsTableHolder">
                    @include('redesign.back.metronic.transactions.pieces.table_fake')
                </div>
            @endif
        </div>
    </div>
@endsection

@section('scripts-page')
    <script src="{{ asset('metronic/vendors/custom/datatables/datatables.bundle.js') }}" type="text/javascript"></script>

    @if( $transactions->count() )

        <script>
            $(document).ready(function() {
                var dt = $('#sellerTransactionsTable').DataTable({
                    order: [],
                    autoWidth: false,
                    dom: '<"col-12"t><"col-12"<"row"<"col-12 col-sm-6 col-xl-4 text-center text-sm-left"l><"col-12 col-sm-6 col-xl-4 text-center text-sm-right text-xl-center"i><"col-12 col-xl-4 text-right"p>>>',
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, 'Alle']],
                    language: {
                        url: '{{ asset('js/plugins/dataTables/i18n/German.json') }}',
                    },
                    responsive: {
                        details: false,
                    },
                    columns: [
                        { responsivePriority: -1 },
                        { responsivePriority: 8 },
                        { responsivePriority: 7 },
                        { responsivePriority: 5 },
                        { responsivePriority: 3 },
                        { responsivePriority: 4 },
                        { responsivePriority: 2 },
                        { responsivePriority: -2, orderable: false },
                    ],
                });

                $('#transactionsSearchInput').on('change keyup', function () {
                    var s = $(this).val().trim();
                    s = s.replace(/\s/g, '');
                    dt.search(s).draw();
                });

                $('#transactionsSearchReset').on('click', function () {
                    $('#transactionsSearchInput').val('').change();
                });

                $('#sellerTransactionsTableHolder').removeClass('d-none');
                $('#overlay').hide();
            });
        </script>

    @else

        <script>
            $(document).ready(function() {
                var dt = $('#sellerTransactionsTable').DataTable({
                    paging: false,
                    info: false,
                    searching: false,
                    autoWidth: false,
                    dom: 't',
                    order: [[ 0, 'asc' ]],
                    language: {
                        url: '{{ asset('js/plugins/dataTables/i18n/German.json') }}',
                    },
                    responsive: {
                        details: false,
                    },
                    columns: [
                        { responsivePriority: -1 },
                        { responsivePriority: 8 },
                        { responsivePriority: 7 },
                        { responsivePriority: 5 },
                        { responsivePriority: 3 },
                        { responsivePriority: 4 },
                        { responsivePriority: 2 },
                        { responsivePriority: -2, orderable: false },
                    ],
                });

                $('#overlay').hide();
            });
        </script>

    @endif
@endsection