@extends('redesign.layouts.metronic.dashboard')

@section('title', 'Unternehmen einladen')

@section('documentTitle', 'Unternehmen einladen')

@section('document')
    <div class="kt-portlet kt-portlet--mobile">
        <div class="kt-portlet__head kt-portlet__head--lg">
            <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon">
                    <i class="fas fa-share-alt"></i>
                </span>
                <h3 class="kt-portlet__head-title">
                    Unternehmen einladen
                </h3>
            </div>
        </div>

        <div class="kt-portlet__body">
            <div class="text-center">
                <h2 class="mb-5">Lade jetzt Unternehmen ein</h2>

                <div class="kt-separator kt-separator--space-lg kt-separator--border-dashed"></div>

                <h3 class="mb-3">Hier ist Dein persönlicher Link um Unternehmen einzuladen</h3>

                <h3 class="mb-5 mt-3" id="refLink">{{ $links->raw }}</h3>

                @include('redesign.back.metronic.share.pieces.buttons_invite')
            </div>
        </div>
    </div>

    @include('redesign.back.metronic.share.pieces.invited_sellers')
@endsection

@section('scripts-page')
    <script>
        window.fbAsyncInit = function() {
            FB.init({
                appId            : {{ config('services.facebook.app_id') }},
                autoLogAppEvents : true,
                xfbml            : true,
                version          : 'v3.2'
            });
        };

        (function(d, s, id){
            var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) {return;}
            js = d.createElement(s); js.id = id;
            js.src = "https://connect.facebook.net/en_US/sdk.js";
            fjs.parentNode.insertBefore(js, fjs);
        }(document, 'script', 'facebook-jssdk'));
    </script>
@endsection