@extends('redesign.layouts.metronic.dashboard')

@section('title', 'Empfehler hinzufügen')

@section('documentTitle', 'Empfehler hinzufügen')

@section('document')
    @if( !$deals->count() )
        <div class="alert alert-warning">
            <div class="alert-icon"><i class="fas fa-exclamation-triangle"></i></div>
            <div class="alert-text">
                Du musst mindestens eine Kampagne erstellen um Empfehler einladen zu konnen.
                <a class="alert-link" href="{{ route('seller.deal.create') }}">
                    <i class="fas fa-plus-circle"></i> Neue Kampagne erstellen
                </a>
            </div>
        </div>
    @endif

    <div class="kt-portlet kt-portlet--mobile">
        <div class="kt-portlet__head kt-portlet__head--lg">
            <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon">
                    <i class="fas fa-share-alt"></i>
                </span>
                <h3 class="kt-portlet__head-title">
                    Empfehler hinzufügen
                </h3>
            </div>
        </div>

        <div class="kt-portlet__body">
            <div class="text-center">
                <h2 class="mb-5">Lade jetzt Deine Empfehler ein</h2>

                <div class="kt-separator kt-separator--space-lg kt-separator--border-dashed"></div>

                <h3 class="mb-3">Hier ist Dein persönlicher Empfehlungslink um Kunden einzuladen</h3>

                @if( !$deals->count() )
                    <h3 class="mb-5 mt-3 noselect" style="opacity: 0.5">{{ $links->raw }}</h3>

                    @include('redesign.back.metronic.share.pieces.buttons_mock')
                @else
                    <h3 class="mb-5 mt-3" id="refLink">{{ $links->raw }}</h3>

                    @include('redesign.back.metronic.share.pieces.buttons')
                @endif
            </div>
        </div>
    </div>
@endsection

@section('scripts-page')
    <script>
        window.fbAsyncInit = function() {
            FB.init({
                appId            : {{ config('services.facebook.app_id') }},
                autoLogAppEvents : true,
                xfbml            : true,
                version          : 'v3.2'
            });
        };

        (function(d, s, id){
            var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) {return;}
            js = d.createElement(s); js.id = id;
            js.src = "https://connect.facebook.net/en_US/sdk.js";
            fjs.parentNode.insertBefore(js, fjs);
        }(document, 'script', 'facebook-jssdk'));
    </script>
@endsection