@extends('redesign.layouts.metronic.dashboard')

@section('title', 'Meine Bewertungen')

@section('documentTitle', 'Meine Bewertungen')

@section('document')
    @if($reviewsCount)
        @include('redesign.back.metronic.reviews.pieces.summary')
    @endif

    <div class="kt-portlet kt-portlet--mobile">
        <div class="kt-portlet__head kt-portlet__head--lg">
            <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon">
                    <i class="fas fa-star"></i>
                </span>
                <h3 class="kt-portlet__head-title">
                    Meine Bewertungen
                    @if( $reviewsCount )
                        <small>
                            @include('redesign.back.metronic.pieces.rating', ['rating' => $reviewsAvg])
                            &Oslash; {{ $reviewsAvg }} aus {{ $reviewsCount }} Bewertungen
                        </small>
                    @endif
                </h3>
            </div>
        </div>

        <div class="kt-portlet__body">
            @if ($reviewsCount)
                <div class="row">
                    @foreach($reviews as $review)
                        @include('redesign.back.metronic.reviews.pieces.review', ['review' => $review])
                    @endforeach
                </div>
            @else
                <div class="pt-5 pb-5 text-center">
                    <h2 class="mb-4">Noch keine Bewertungen vorhanden.</h2>
                    <a class="btn btn-primary" href="{{ route('home') }}">
                        <i class="fas fa-tachometer-alt"></i> Zum Dashboard
                    </a>
                </div>
            @endif
        </div>
    </div>
@endsection