<div class="kt-portlet" data-profile-tab="private">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h3 class="kt-portlet__head-title">Persönliche Daten</h3>
        </div>
    </div>

    <div class="kt-portlet__body">
        <div class="kt-section kt-section--first">
            <div class="kt-section__body kt-form kt-form--label-right">
                <div class="row">
                    <label class="col-xl-3"></label>
                    <div class="col-lg-9 col-xl-6">
                        <h3 class="kt-section__title kt-section__title-sm">Eigenes Foto</h3>
                    </div>
                </div>

                <div class="pictureUploadHolder" data-form="userProfilePictureForm">
                    <div class="form-group row @if ($errors->has('portrait')) validated @endif">
                        <label class="col-xl-3 col-lg-3 col-form-label">Eigenes Foto</label>
                        <div class="col-lg-9 col-xl-6">
                            <div class="kt-avatar kt-avatar--outline">
                                <div class="kt-avatar__holder pictureHolder" style="background-image: url('{{ $user->userpic }}');" data-bg="url({{ $user->userpic }})"></div>
                                <label class="kt-avatar__upload pictureSelectBtn" data-toggle="kt-tooltip" title="" data-original-title="Auswählen">
                                    <i class="fa fa-pen"></i>
                                </label>
                                <span class="kt-avatar__cancel pictureCancelBtn" data-toggle="kt-tooltip" title="" data-original-title="Abbrechen">
                                    <i class="fa fa-times"></i>
                                </span>
                            </div>
                            <div class="invalid-feedback">{{ $errors->first('portrait') }}</div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <div class="col-lg-3 col-xl-3"></div>
                        <div class="col-lg-9 col-xl-9">
                            <div class="btn btn-success disabled pictureUploadBtn">Speichern</div>
                        </div>
                    </div>
                </div>

                <div class="kt-separator kt-separator--border-dashed kt-separator--space-xl"></div>

                <div class="row">
                    <label class="col-xl-3"></label>
                    <div class="col-lg-9 col-xl-6">
                        <h3 class="kt-section__title kt-section__title-sm">Persönliche Daten</h3>
                    </div>
                </div>

                <form action="{{ route('api.change-personal') }}" id="privateDataForm">
                    <div class="form-group row">
                        <label class="col-xl-3 col-lg-3 col-form-label">Anrede</label>
                        <div class="col-lg-9 col-xl-6">
                            <select class="custom-select userProfileInput" id="userProfileSalutation" name="salutation">
                                <option disabled>Bitte wählen</option>
                                <option value="Herr" @if('Herr' === $user->salutation) selected @endif>Herr</option>
                                <option value="Frau" @if('Frau' === $user->salutation) selected @endif>Frau</option>
                            </select>
                            <div class="invalid-feedback" data-input="salutation"></div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-xl-3 col-lg-3 col-form-label">Vorname</label>
                        <div class="col-lg-9 col-xl-6">
                            <input type="text" class="form-control userProfileInput" id="userProfileName" name="firstname" placeholder="Vorname" value="{{ $user->firstname }}">
                            <div class="invalid-feedback" data-input="firstname"></div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-xl-3 col-lg-3 col-form-label">Nachname</label>
                        <div class="col-lg-9 col-xl-6">
                            <input type="text" class="form-control userProfileInput" id="userProfileSurname" name="surname" placeholder="Nachname" value="{{ $user->surname }}">
                            <div class="invalid-feedback" data-input="surname"></div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-3 col-xl-3">
                        </div>
                        <div class="col-lg-9 col-xl-9">
                            <div class="btn btn-success userProfileSaveBtn" data-form="privateDataForm">Speichern</div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<form action="{{ route('user.set-userpic') }}" method="post" class="d-none" id="userProfilePictureForm" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="file" class="pictureInput" name="portrait" accept="image/*" />
</form>