<div class="kt-portlet d-none" data-profile-tab="firm">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h3 class="kt-portlet__head-title">Unternehmensdaten</h3>
        </div>
    </div>

    <div class="kt-portlet__body">
        <div class="kt-section kt-section--first">
            <div class="kt-section__body kt-form kt-form--label-right">
                <div class="row">
                    <label class="col-xl-3"></label>
                    <div class="col-lg-9 col-xl-6">
                        <h3 class="kt-section__title kt-section__title-sm">Firmenlogo</h3>
                    </div>
                </div>

                <div class="pictureUploadHolder" data-form="sellerLogoForm">
                    <div class="form-group row @if ($errors->has('logo')) validated @endif">
                        <label class="col-xl-3 col-lg-3 col-form-label">Firmenlogo</label>
                        <div class="col-lg-9 col-xl-6">
                            <div class="kt-avatar kt-avatar--outline">
                                <div class="kt-avatar__holder pictureHolder" style="background-image: url('{{ $user->account->logo }}');" data-bg="url({{ $user->account->logo }})"></div>
                                <label class="kt-avatar__upload pictureSelectBtn" data-toggle="kt-tooltip" title="" data-original-title="Auswählen">
                                    <i class="fa fa-pen"></i>
                                </label>
                                <span class="kt-avatar__cancel pictureCancelBtn" data-toggle="kt-tooltip" title="" data-original-title="Abbrechen">
                                    <i class="fa fa-times"></i>
                                </span>
                            </div>
                            <div class="invalid-feedback">{{ $errors->first('logo') }}</div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <div class="col-lg-3 col-xl-3"></div>
                        <div class="col-lg-9 col-xl-9">
                            <div class="btn btn-success disabled pictureUploadBtn">Speichern</div>
                        </div>
                    </div>
                </div>

                <div class="kt-separator kt-separator--border-dashed kt-separator--space-xl"></div>

                <div class="row">
                    <label class="col-xl-3"></label>
                    <div class="col-lg-9 col-xl-6">
                        <h3 class="kt-section__title kt-section__title-sm">Firmenbild</h3>
                    </div>
                </div>

                <div class="pictureUploadHolder" data-form="sellerPictureForm">
                    <div class="form-group row @if ($errors->has('picture')) validated @endif">
                        <label class="col-xl-3 col-lg-3 col-form-label">Firmenbild</label>
                        <div class="col-lg-9 col-xl-6">
                            <div class="kt-avatar kt-avatar--outline" style="width:100%;">
                                <div class="kt-avatar__holder pictureHolder" style="width:100%; height: 300px; background-image: url('{{ asset($user->account->picture ?? '/account/portraits/business.png') }}');" data-bg="url({{ asset($user->account->picture ?? '/account/portraits/business.png') }})"></div>
                                <label class="kt-avatar__upload pictureSelectBtn" data-toggle="kt-tooltip" title="" data-original-title="Auswählen">
                                    <i class="fa fa-pen"></i>
                                </label>
                                <span class="kt-avatar__cancel pictureCancelBtn" data-toggle="kt-tooltip" title="" data-original-title="Abbrechen">
                                    <i class="fa fa-times"></i>
                                </span>
                            </div>
                            <div class="invalid-feedback">{{ $errors->first('picture') }}</div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <div class="col-lg-3 col-xl-3"></div>
                        <div class="col-lg-9 col-xl-9">
                            <div class="btn btn-success disabled pictureUploadBtn">Speichern</div>
                        </div>
                    </div>
                </div>

                <div class="kt-separator kt-separator--border-dashed kt-separator--space-xl"></div>

                <div class="row">
                    <label class="col-xl-3"></label>
                    <div class="col-lg-9 col-xl-6">
                        <h3 class="kt-section__title kt-section__title-sm">Unternehmensdaten</h3>
                    </div>
                </div>

                <form action="{{ route('api.change-company') }}" id="companyDataForm">
                    <div class="form-group row">
                        <label class="col-xl-3 col-lg-3 col-form-label">Firmenname</label>
                        <div class="col-lg-9 col-xl-6">
                            <input type="text" class="form-control userProfileInput" id="userProfileCompany" name="company" placeholder="Firmenname" value="{{ $user->account->company }}">
                            <div class="invalid-feedback" data-input="company"></div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-xl-3 col-lg-3 col-form-label">Beschreibung</label>
                        <div class="col-lg-9 col-xl-6">
                            <textarea rows="5" class="form-control userProfileInput" id="userProfileDescr" name="description" placeholder="Beschreibung">{{ $user->account->description }}</textarea>
                            <div class="invalid-feedback" data-input="description"></div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-3 col-xl-3">
                        </div>
                        <div class="col-lg-9 col-xl-9">
                            <div class="btn btn-success userProfileSaveBtn" data-form="companyDataForm">Speichern</div>
                        </div>
                    </div>
                </form>

                <div class="kt-separator kt-separator--border-dashed kt-separator--space-xl"></div>

                <div class="row">
                    <label class="col-xl-3"></label>
                    <div class="col-lg-9 col-xl-6">
                        <h3 class="kt-section__title kt-section__title-sm">Kontaktdaten</h3>
                    </div>
                </div>

                <form action="{{ route('api.change-address') }}" id="contactsDataForm">
                    <div class="form-group row">
                        <label class="col-xl-3 col-lg-3 col-form-label">Straße</label>
                        <div class="col-lg-9 col-xl-6">
                            <input type="text" class="form-control userProfileInput" id="userProfileStreet" name="street" placeholder="Straße" value="{{ $user->account->street }}">
                            <div class="invalid-feedback" data-input="street"></div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-xl-3 col-lg-3 col-form-label">Hausnummer</label>
                        <div class="col-lg-9 col-xl-6">
                            <input type="text" class="form-control userProfileInput" id="userProfileHousenumber" name="housenumber" placeholder="Hausnummer" value="{{ $user->account->housenumber }}">
                            <div class="invalid-feedback" data-input="housenumber"></div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-xl-3 col-lg-3 col-form-label">PLZ</label>
                        <div class="col-lg-9 col-xl-6">
                            <input type="text" class="form-control userProfileInput" id="userProfileZIP" name="zip" placeholder="PLZ" value="{{ $user->account->zip }}" maxlength="5">
                            <div class="invalid-feedback" data-input="zip"></div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-xl-3 col-lg-3 col-form-label">Ort</label>
                        <div class="col-lg-9 col-xl-6">
                            <input type="text" class="form-control userProfileInput" id="userProfileCity" name="city" placeholder="Ort" value="{{ $user->account->city }}">
                            <div class="invalid-feedback" data-input="city"></div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-xl-3 col-lg-3 col-form-label">Telefon</label>
                        <div class="col-lg-9 col-xl-6">
                            <input type="text" class="form-control userProfileInput" id="userProfilePhone" name="phone" placeholder="Telefon" value="{{ $user->phone }}">
                            <div class="invalid-feedback" data-input="phone"></div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-xl-3 col-lg-3 col-form-label">Kontakt E-Mail</label>
                        <div class="col-lg-9 col-xl-6">
                            <input type="text" class="form-control userProfileInput" id="userProfileEmail" name="email" placeholder="Kontakt E-Mail" value="{{ $user->account->email }}">
                            <div class="invalid-feedback" data-input="email"></div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-3 col-xl-3">
                        </div>
                        <div class="col-lg-9 col-xl-9">
                            <div class="btn btn-success userProfileSaveBtn" data-form="contactsDataForm">Speichern</div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<form action="{{ route('user.set-logo') }}" method="post" class="d-none" id="sellerLogoForm" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="file" class="pictureInput" name="logo" accept="image/*" />
</form>

<form action="{{ route('user.set-picture') }}" method="post" class="d-none" id="sellerPictureForm" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="file" class="pictureInput" name="picture" accept="image/*" />
</form>