@extends('redesign.layouts.metronic.dashboard')

@section('title', 'Profil')

@section('documentTitle', 'Profil')

@section('styles-page')
    <link href="{{ asset('css/flags16.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('document')
    @if( session('warning') )
        @include('redesign.back.metronic.pieces.alert', [
            'type' => 'danger',
            'icon' => '<i class="fas fa-exclamation-triangle"></i>',
            'text' => session('warning'),
            'close' => true,
        ])
    @endif

    <div class="kt-grid kt-grid--desktop kt-grid--ver kt-grid--ver-desktop kt-app">
        @include('redesign.back.metronic.profile.pieces.aside')

        <div class="kt-grid__item kt-grid__item--fluid kt-app__content">
            <div class="row">
                <div class="col-xl-12" data-profile-tabs>
                    @include('redesign.back.metronic.profile.pieces.private')

                    @include('redesign.back.metronic.profile.pieces.email')

                    @include('redesign.back.metronic.profile.pieces.security')

                    @include('redesign.back.metronic.profile.pieces.newsletter')
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts-page')
    <script src="{{ asset('js/plugins/zxcvbn/zxcvbn.js') }}"></script>
    <script src="{{ asset('metronic/js/scripts/profile.js') }}"></script>
@endsection