@extends('redesign.layouts.metronic.dashboard')

@section('title', 'Standort erstellen')

@section('documentTitle', 'Standort erstellen')

@section('document')
    @if( session('warning') )
        @include('redesign.back.metronic.pieces.alert', [
            'type' => 'danger',
            'icon' => '<i class="fas fa-exclamation-triangle"></i>',
            'text' => session('warning'),
            'close' => true,
        ])
    @endif

    <div class="kt-portlet kt-portlet--mobile">
        <div class="kt-portlet__head kt-portlet__head--lg">
            <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon">
                    <i class="fas fa-plus-circle"></i>
                </span>
                <h3 class="kt-portlet__head-title">
                    Standort erstellen
                </h3>
            </div>
        </div>

        <form action="{{ route('seller.place.create') }}" method="post">
            {{ csrf_field() }}

            <div class="kt-portlet__body">
                @include('redesign.back.metronic.places.pieces.form')
            </div>

            <div class="kt-portlet__foot">
                <div class="row align-items-center">
                    <div class="col">
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-save"></i>
                            Erstellen
                        </button>
                    </div>
                    <div class="col text-right">
                        <a class="btn btn-secondary" href="{{ route('seller.places.index') }}">
                            <i class="fas fa-ban"></i>
                            Abbrechen
                        </a>
                    </div>
                </div>
            </div>

        </form>
    </div>
@endsection