<tr>
    <td>[id={{ $place->id }}]</td>
    <td class="align-middle d-xl-none address-cell">
        <span class="place-address" title="{{ $place->address }}">{{ $place->address }}</span>
    </td>
    <td class="align-middle d-none d-xl-table-cell">
        {{ $place->zip }}
    </td>
    <td class="align-middle d-none d-xl-table-cell">
        {{ $place->city }}
    </td>
    <td class="align-middle d-none d-xl-table-cell">
        {{ $place->street }}
    </td>
    <td class="align-middle d-none d-xl-table-cell">
        {{ $place->housenumber }}
    </td>
    <td class="align-middle d-none d-lg-table-cell">
        Tel.: {{ $place->phone }}
        @if($place->email)
            <br>E-Mail: {{ $place->email }}
        @endif
    </td>
    <td class="align-middle text-monospace d-none d-xl-table-cell">
        @if($place->wt_mon)
            <span class="badge badge-secondary" data-toggle="kt-tooltip" data-title="{{ $place->wt_mon }}">Mo</span>
        @endif

        @if($place->wt_tue)
            <span class="badge badge-secondary" data-toggle="kt-tooltip" data-title="{{ $place->wt_tue }}">Di</span>
        @endif

        @if($place->wt_wed)
            <span class="badge badge-secondary" data-toggle="kt-tooltip" data-title="{{ $place->wt_wed }}">Mi</span>
        @endif

        @if($place->wt_thu)
            <span class="badge badge-secondary" data-toggle="kt-tooltip" data-title="{{ $place->wt_thu }}">Do</span>
        @endif

        @if($place->wt_fri)
            <span class="badge badge-secondary" data-toggle="kt-tooltip" data-title="{{ $place->wt_fri }}">Fr</span>
        @endif

        @if($place->wt_sat)
            <span class="badge badge-secondary" data-toggle="kt-tooltip" data-title="{{ $place->wt_sat }}">Sa</span>
        @endif

        @if($place->wt_sun)
            <span class="badge badge-secondary" data-toggle="kt-tooltip" data-title="{{ $place->wt_sun }}">So</span>
        @endif
    </td>
    <td class="align-middle">
        {{ $place->present()->status_metronic }}
    </td>
    <td class="align-middle">
        <span class="dropdown">
            <a href="#" class="btn btn-sm btn-clean btn-icon btn-icon-md" data-toggle="dropdown" aria-expanded="false">
                <i class="fas fa-ellipsis-h"></i>
            </a>

            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end">
                <div class="dropdown-item showItemInfo" style="cursor:pointer" data-mid="p{{ $place->id }}"><i class="fas fa-info"></i> Information</div>

                @if( $user->canDo('edit places', true) )
                    @if(App\Place::STATUS_ACTIVE === $place->status)
                        <a class="dropdown-item" href="{{ route('seller.place.deactivate', $place) }}"><i class="fas fa-toggle-off"></i> Deaktivieren</a>
                    @else
                        <a class="dropdown-item" href="{{ route('seller.place.activate', $place) }}"><i class="fas fa-toggle-on"></i> Aktivieren</a>
                    @endif
                    <a class="dropdown-item" href="{{ route('seller.place.edit', $place) }}"><i class="fas fa-pencil-alt"></i> Bearbeiten</a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item placeDeleteBtn" href="{{ route('seller.place.delete', $place) }}"><i class="fas fa-trash"></i> Löschen</a>
                @endif
            </div>
        </span>
    </td>
</tr>