@include('redesign.back.metronic.pieces.alert', [
    'type' => 'info',
    'icon' => '<i class="fas fa-info-circle"></i>',
    'text' => '<span class="star">*</span> Pflichtangabe',
])

<div class="kt-section kt-section--first">
    <div class="kt-section__body kt-form kt-form--label-right">

        <div class="row">
            <label class="col-xl-3"></label>
            <div class="col-lg-9 col-xl-6">
                <h3 class="kt-section__title kt-section__title-sm">Kontaktdaten</h3>
            </div>
        </div>

        @if($errors->has('geo'))
            @include('redesign.back.metronic.pieces.alert', [
                'type' => 'danger',
                'icon' => '<i class="fas fa-exclamation-triangle"></i>',
                'text' => $errors->first('geo'),
            ])
        @endif

        <div class="form-group row @if ($errors->has('street')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">Straße <span class="star">*</span></label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('street')) is-invalid @endif" id="placeStreet" name="street" placeholder="Straße" value="{{ old('street', isset($place) ? $place->street : '') }}">
                <div class="invalid-feedback">{{ $errors->first('street') }}</div>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('housenumber')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">Hausnummer <span class="star">*</span></label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('housenumber')) is-invalid @endif" id="placeHousenumber" name="housenumber" placeholder="Hausnummer" value="{{ old('housenumber', isset($place) ? $place->housenumber : '') }}">
                <div class="invalid-feedback">{{ $errors->first('housenumber') }}</div>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('zip')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">PLZ <span class="star">*</span></label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('zip')) is-invalid @endif" id="placeZip" name="zip" placeholder="PLZ" value="{{ old('zip', isset($place) ? $place->zip : '') }}" maxlength="5">
                <div class="invalid-feedback">{{ $errors->first('zip') }}</div>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('city')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">Ort <span class="star">*</span></label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('city')) is-invalid @endif" id="placeCity" name="city" placeholder="Ort" value="{{ old('city', isset($place) ? $place->city : '') }}">
                <div class="invalid-feedback">{{ $errors->first('city') }}</div>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('phone')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">Telefon</label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('phone')) is-invalid @endif" id="placePhone" name="phone" placeholder="Telefon" value="{{ old('phone', isset($place) ? $place->phone : '') }}">
                <div class="invalid-feedback">{{ $errors->first('phone') }}</div>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('email')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">E-Mail</label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('email')) is-invalid @endif" id="placeEmail" name="email" placeholder="E-Mail" value="{{ old('email', isset($place) ? $place->email : '') }}">
                <div class="invalid-feedback">{{ $errors->first('email') }}</div>
            </div>
        </div>

        <div class="row">
            <label class="col-xl-3"></label>
            <div class="col-lg-9 col-xl-6">
                <h3 class="kt-section__title kt-section__title-sm">Öffnungszeiten</h3>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('wt_mon')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">Montag</label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('wt_mon')) is-invalid @endif" id="placeWtMon" name="wt_mon" placeholder="Montag" value="{{ old('wt_mon', isset($place) ? $place->wt_mon : '') }}">
                <div class="invalid-feedback">{{ $errors->first('wt_mon') }}</div>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('wt_tue')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">Dienstag</label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('wt_tue')) is-invalid @endif" id="placeWtTue" name="wt_tue" placeholder="Dienstag" value="{{ old('wt_tue', isset($place) ? $place->wt_tue : '') }}">
                <div class="invalid-feedback">{{ $errors->first('wt_tue') }}</div>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('wt_wed')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">Mittwoch</label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('wt_wed')) is-invalid @endif" id="placeWtWed" name="wt_wed" placeholder="Mittwoch" value="{{ old('wt_wed', isset($place) ? $place->wt_wed : '') }}">
                <div class="invalid-feedback">{{ $errors->first('wt_wed') }}</div>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('wt_thu')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">Donnerstag</label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('wt_thu')) is-invalid @endif" id="placeWtThu" name="wt_thu" placeholder="Donnerstag" value="{{ old('wt_thu', isset($place) ? $place->wt_thu : '') }}">
                <div class="invalid-feedback">{{ $errors->first('wt_thu') }}</div>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('wt_fri')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">Freitag</label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('wt_fri')) is-invalid @endif" id="placeWtFri" name="wt_fri" placeholder="Freitag" value="{{ old('wt_fri', isset($place) ? $place->wt_fri : '') }}">
                <div class="invalid-feedback">{{ $errors->first('wt_fri') }}</div>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('wt_sat')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">Samstag</label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('wt_sat')) is-invalid @endif" id="placeWtSat" name="wt_sat" placeholder="Samstag" value="{{ old('wt_sat', isset($place) ? $place->wt_sat : '') }}">
                <div class="invalid-feedback">{{ $errors->first('wt_sat') }}</div>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('wt_sun')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">Sonntag</label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('wt_sun')) is-invalid @endif" id="placeWtSun" name="wt_sun" placeholder="Sonntag" value="{{ old('wt_sun', isset($place) ? $place->wt_sun : '') }}">
                <div class="invalid-feedback">{{ $errors->first('wt_sun') }}</div>
            </div>
        </div>
    </div>
</div>