@extends('redesign.layouts.metronic.dashboard')

@section('title', 'Standorte')

@section('documentTitle', 'Standorte')

@section('overlay-style', 'display:block')

@section('styles-page')
    <link href="{{ asset('metronic/vendors/custom/datatables/datatables.bundle.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('document')
    <div class="kt-portlet kt-portlet--mobile">
        <div class="kt-portlet__head kt-portlet__head--lg">
            <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon">
                    <i class="fas fa-store"></i>
                </span>
                <h3 class="kt-portlet__head-title">
                    Standorte
                </h3>
            </div>

            @if( $user->canDo('create places', true) )
            <div class="kt-portlet__head-toolbar">
                <div class="kt-portlet__head-wrapper">
                    <div class="kt-portlet__head-actions">
                        <a href="{{ route('seller.place.store') }}" class="btn btn-brand btn-elevate btn-icon-sm">
                            <i class="fas fa-plus-circle"></i> Neuen Standort erstellen
                        </a>
                    </div>
                </div>
            </div>
            @endif
        </div>

        <div class="kt-portlet__body">
            @if( $places->count() )
                <div class="mb-4">
                    <div class="form-group col-12 inputHolder">
                        <label for="placesSearchInput">Suche</label>
                        <div class="input-group">
                            <input type="search" class="form-control" id="placesSearchInput" placeholder="Beginne zu suchen">
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary" type="button" id="placesSearchReset">
                                    <i class="fas fa-ban"></i> Zurücksetzen
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="sellerPlacesTableHolder" class="d-none">
                    @include('redesign.back.metronic.places.pieces.table')
                </div>

                <form action="" method="post" class="d-none" id="placeDeleteForm">
                    {{ csrf_field() }}
                    {{ method_field('DELETE') }}
                </form>
            @else
                <div class="pt-5 pb-5 text-center">
                    <h2 class="mb-4">Noch keine Standorte.</h2>
                    @if( $user->canDo('create places', true) )
                    <a class="btn btn-primary" href="{{ route('seller.place.store') }}">
                        <i class="fas fa-plus-circle"></i> Neuen Standort erstellen
                    </a>
                    @endif
                </div>

                <div id="sellerPlacesTableHolder">
                    @include('redesign.back.metronic.places.pieces.table_fake')
                </div>
            @endif
        </div>
    </div>
@endsection

@section('scripts-page')
    <script src="{{ asset('metronic/vendors/custom/datatables/datatables.bundle.js') }}" type="text/javascript"></script>

    @if( $places->count() )

        <script>
            $(document).ready(function() {
                var dt = $('#sellerPlacesTable').DataTable({
                    order: [],
                    autoWidth: false,
                    dom: '<"col-12"t><"col-12"<"row"<"col-12 col-sm-6 col-xl-4 text-center text-sm-left"l><"col-12 col-sm-6 col-xl-4 text-center text-sm-right text-xl-center"i><"col-12 col-xl-4 text-right"p>>>',
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, 'Alle']],
                    language: {
                        url: '{{ asset('js/plugins/dataTables/i18n/German.json') }}',
                    },
                    columns: [
                        {visible: false}, null, null, null, null, null, null, null, null, {orderable: false},
                    ],
                });

                $('#placesSearchInput').on('change keyup', function () {
                    var s = $(this).val().trim();
                    s = s.replace(/\s/g, '');
                    dt.search(s).draw();
                });

                $('#placesSearchReset').on('click', function () {
                    $('#placesSearchInput').val('').change();
                });

                $('.placeDeleteBtn').on('click', function (e) {
                    e.preventDefault();
                    e.stopPropagation();

                    swal.fire({
                        title: 'Bist Du sicher?',
                        text: 'Aktion ist nicht kündbar',
                        type: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Ja',
                        cancelButtonText: 'Nein',
                        focusConfirm: false,
                        focusCancel: true,
                        heightAuto: false,
                    }).then((result) => {
                        if (result.value) {
                            $('#placeDeleteForm')
                                .attr('action', $(this).attr('href'))
                                .submit();
                        }
                    });
                });

                var url = new URL(window.location.href);
                var s = url.searchParams.get('s');

                if (null !== s) {
                    $('#placesSearchInput').val(s).change();
                }

                $('#sellerPlacesTableHolder').removeClass('d-none');
                $('#overlay').hide();
            });
        </script>

    @else

        <script>
            $(document).ready(function() {
                $('#sellerPlacesTable').DataTable({
                    paging: false,
                    info: false,
                    searching: false,
                    autoWidth: false,
                    dom: 't',
                    order: [[ 0, 'asc' ]],
                    columns: [
                        null, null, null, null, null, null, null, null, {orderable: false},
                    ],
                });

                $('#overlay').hide();
            });
        </script>

    @endif
@endsection