@extends('redesign.layouts.metronic.dashboard')

@section('title', 'Standort bearbeiten')

@section('documentTitle', 'Standort bearbeiten')

@section('document')
    <div class="kt-portlet kt-portlet--mobile">
        <div class="kt-portlet__head kt-portlet__head--lg">
            <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon">
                    <i class="fas fa-edit"></i>
                </span>
                <h3 class="kt-portlet__head-title">
                    Standort bearbeiten
                </h3>
            </div>
        </div>

        <form action="{{ route('seller.place.update', ['place' => $place]) }}" method="post">
            {{ csrf_field() }}

            <div class="kt-portlet__body">
                @include('redesign.back.metronic.places.pieces.form')
            </div>

            <div class="kt-portlet__foot">
                <div class="row align-items-center">
                    <div class="col">
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-save"></i>
                            Speichern
                        </button>
                    </div>
                    <div class="col text-right">
                        <a class="btn btn-secondary" href="{{ route('seller.places.index') }}">
                            <i class="fas fa-ban"></i>
                            Abbrechen
                        </a>
                    </div>
                </div>
            </div>

        </form>
    </div>
@endsection