<tr>
    <td class="align-middle">
        @include('redesign.back.metronic.pieces.user_card', [
            'img' => $employee->userpic,
            'title' => $employee->fullname,
        ])
    </td>
    <td class="align-middle">
        {{ $employee->email }}
    </td>
    <td class="align-middle" data-order="{{ $employee->created_at }}">
        {{ $employee->present()->creationDate }}
    </td>
    <td class="align-middle">
        {{ $employee->redeems_count }}
    </td>
    <td class="align-middle">
        {{ $employee->referrals_count }}
    </td>
    <td class="align-middle">
        {{ $employee->invited_sellers_count }}
    </td>
    <td class="align-middle">
        {{ $employee->present()->statusMetronic }}
    </td>
    <td class="align-middle">
        <span class="dropdown">
            <a href="#" class="btn btn-sm btn-clean btn-icon btn-icon-md" data-toggle="dropdown" aria-expanded="false">
                <i class="fas fa-ellipsis-h"></i>
            </a>

            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end">
                <div class="dropdown-item showItemInfo" data-mid="e{{ $employee->id }}"><i class="fas fa-info"></i> Information</div>

                <div class="dropdown-item employeeShowLog" data-id="{{ $employee->id }}"><i class="fas fa-book"></i> Log</div>

                @if(App\User::STATUS_PENDING === $employee->status)
                    <div class="dropdown-item employeeLinkResendBtn" data-id="{{ $employee->id }}"><i class="fas fa-envelope"></i> Einladung erneut senden</div>
                @else
                    @if(App\User::STATUS_ACTIVE === $employee->status)
                        <a class="dropdown-item" href="{{ route('seller.employee.deactivate', $employee) }}"><i class="fas fa-toggle-off"></i> Deaktivieren</a>
                    @else
                        <a class="dropdown-item" href="{{ route('seller.employee.activate', $employee) }}"><i class="fas fa-toggle-on"></i> Aktivieren</a>
                    @endif
                @endif

                <a class="dropdown-item" href="{{ route('seller.employee.edit', $employee) }}"><i class="fas fa-pencil-alt"></i> Bearbeiten</a>

                <div class="dropdown-divider"></div>

                <a class="dropdown-item employeeDeleteBtn" href="{{ route('seller.employee.delete', $employee) }}"><i class="fas fa-trash"></i> Löschen</a>
            </div>
        </span>
    </td>
</tr>