<div class="modal" tabindex="-1" role="dialog" id="e{{ $employee->id }}">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ $employee->fullname  }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table table-striped table-borderless">
                    <thead>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Mitarbeiter</td>
                            <td>
                                @include('redesign.back.metronic.pieces.user_card', [
                                    'img' => $employee->userpic,
                                    'title' => $employee->fullname,
                                ])
                            </td>
                        </tr>
                        <tr>
                            <td>E-Mail</td>
                            <td>{{ $employee->email }}</td>
                        </tr>
                        <tr>
                            <td>Eingetragen</td>
                            <td>{{ $employee->present()->creationDate }}</td>
                        </tr>
                        <tr>
                            <td>Einlösungen</td>
                            <td>{{ $employee->redeems_count }}</td>
                        </tr>
                        <tr>
                            <td>Einladungen</td>
                            <td>{{ $employee->referrals_count }}</td>
                        </tr>
                        <tr>
                            <td>Unternehmen</td>
                            <td>{{ $employee->invited_sellers_count }}</td>
                        </tr>
                        <tr>
                            <td>Status</td>
                            <td>{{ $employee->present()->statusMetronic }}</td>
                        </tr>
                        <tr>
                            <td>Berechtigungen</td>
                            <td>
                                @foreach(\App\User::EMPLOYEE_PERMISSIONS as $permission)
                                    <p>
                                        @if( $employee->canDo($permission) )
                                            <i class="fas fa-check kt-font-success"></i>
                                        @else
                                            <i class="fas fa-times kt-font-danger"></i>
                                        @endif
                                        @lang('permissions.' . $permission)
                                    </p>
                                @endforeach
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Schließen</button>
            </div>
        </div>
    </div>
</div>