@if( isset($employee) && \App\User::STATUS_PENDING !== $employee->status )

    @include('redesign.back.metronic.pieces.alert', [
        'type' => 'warning',
        'text' => 'Persönliche Daten sind nicht editierbar. Mitarbeiter bearbeiten es selbst seit er hat sein Profil aktiviert.',
    ])

@else

    @include('redesign.back.metronic.pieces.alert', [
        'type' => 'info',
        'icon' => '<i class="fas fa-info-circle"></i>',
        'text' => '<span class="star">*</span> Pflichtangabe',
    ])

@endif

<div class="kt-section kt-section--first">
    <div class="kt-section__body kt-form kt-form--label-right">

        <div class="row">
            <label class="col-xl-3"></label>
            <div class="col-lg-9 col-xl-6">
                <h3 class="kt-section__title kt-section__title-sm">Persönliche Daten</h3>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('email')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">E-Mail @if( !(isset($employee) && \App\User::STATUS_PENDING !== $employee->status) ) <span class="star">*</span> @endif</label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('email')) is-invalid @endif" id="employeeEmail" name="email" placeholder="E-Mail" value="{{ old('email', isset($employee) ? $employee->email : '') }}" @if( isset($employee) && \App\User::STATUS_PENDING !== $employee->status ) disabled readonly @endif>
                <div class="invalid-feedback">{{ $errors->first('email') }}</div>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('salutation')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">Anrede</label>
            <div class="col-lg-9 col-xl-6">
                <select class="custom-select userProfileInput" id="employeeSalutation" name="salutation" @if( isset($employee) && \App\User::STATUS_PENDING !== $employee->status ) disabled readonly @endif>
                    <option disabled>Bitte wählen</option>
                    <option value="Herr" @if( 'Herr' === old('salutation', isset($employee) ? $employee->salutation : '') ) selected @endif>Herr</option>
                    <option value="Frau" @if( 'Frau' === old('salutation', isset($employee) ? $employee->salutation : '') ) selected @endif>Frau</option>
                </select>
                <div class="invalid-feedback">{{ $errors->first('salutation') }}</div>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('firstname')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">Vorname</label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('firstname')) is-invalid @endif" id="employeeName" name="firstname" placeholder="Vorname" value="{{ old('firstname', isset($employee) ? $employee->firstname : '') }}" @if( isset($employee) && \App\User::STATUS_PENDING !== $employee->status ) disabled readonly @endif>
                <div class="invalid-feedback">{{ $errors->first('firstname') }}</div>
            </div>
        </div>

        <div class="form-group row @if ($errors->has('surname')) validated @endif">
            <label class="col-xl-3 col-lg-3 col-form-label">Nachname</label>
            <div class="col-lg-9 col-xl-6">
                <input type="text" class="form-control @if ($errors->has('surname')) is-invalid @endif" id="employeeSurname" name="surname" placeholder="Nachname" value="{{ old('surname', isset($employee) ? $employee->surname : '') }}" @if( isset($employee) && \App\User::STATUS_PENDING !== $employee->status ) disabled readonly @endif>
                <div class="invalid-feedback">{{ $errors->first('surname') }}</div>
            </div>
        </div>

        @if( isset($employee) )
            <div class="form-group row">
                <label class="col-xl-3 col-lg-3 col-form-label">Status</label>
                <div class="col-lg-9 col-xl-6 col-form-label">
                    {{ $employee->present()->statusMetronic }}
                </div>
            </div>
        @endif

        <div class="row">
            <label class="col-xl-3"></label>
            <div class="col-lg-9 col-xl-6">
                <h3 class="kt-section__title kt-section__title-sm">Berechtigungen</h3>
            </div>
        </div>

        <div class="form-group row">
            <label class="col-xl-3 col-lg-3 col-form-label"></label>
            <div class="col-lg-9 col-xl-6">
                <div class="kt-checkbox-list">
                    <label class="kt-checkbox kt-checkbox--bold kt-checkbox--brand">
                        <input id="permsCheckboxAll" type="checkbox"> Alle auswählen
                        <span></span>
                    </label>

                    <span class="form-text text-muted">&nbsp;</span>

                    @foreach($permissions as $permission)
                        <label class="kt-checkbox kt-checkbox--bold kt-checkbox--brand">
                            <input class="permsCheckbox" type="checkbox" name="permissions[]" value="{{ $permission }}" @if( isset($employee) && $employee->canDo($permission) ) checked @endif>
                            @lang('permissions.' . $permission)
                            <span></span>
                        </label>
                    @endforeach
                </div>
            </div>
        </div>

    </div>
</div>

