@extends('redesign.layouts.metronic.dashboard')

@section('title', 'Meine Mitarbeiter')

@section('documentTitle', 'Meine Mitarbeiter')

@section('overlay-style', 'display:block')

@section('styles-page')
    <link href="{{ asset('metronic/vendors/custom/datatables/datatables.bundle.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('document')
    <div class="kt-portlet kt-portlet--mobile">
        <div class="kt-portlet__head kt-portlet__head--lg">
            <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon">
                    <i class="fas fa-ticket-alt"></i>
                </span>
                <h3 class="kt-portlet__head-title">
                    Meine Mitarbeiter
                </h3>
            </div>
            <div class="kt-portlet__head-toolbar">
                <div class="kt-portlet__head-wrapper">
                    <div class="kt-portlet__head-actions">
                        <a href="{{ route('seller.employee.store') }}" class="btn btn-brand btn-elevate btn-icon-sm">
                            <i class="fas fa-plus-circle"></i> Neuen Mitarbeiter erstellen
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="kt-portlet__body">
            @if( $employees->count() )
                <div class="mb-4">
                    <div class="form-group col-12 inputHolder">
                        <label for="employeeSearchInput">Mitarbeiter suche</label>
                        <div class="input-group">
                            <input type="search" class="form-control" id="employeeSearchInput" placeholder="Beginne zu suchen">
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary" type="button" id="employeeSearchReset">
                                    <i class="fas fa-ban"></i> Zurücksetzen
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="sellerEmployeesTableHolder" class="d-none">
                    @include('redesign.back.metronic.employees.pieces.table')
                </div>

                <form action="" method="post" class="d-none" id="employeeDeleteForm">
                    {{ csrf_field() }}
                    {{ method_field('DELETE') }}
                </form>
            @else
                <div class="pt-5 pb-5 text-center">
                    <h2 class="mb-4">Noch keine Mitarbeiter.</h2>
                    <a class="btn btn-primary" href="{{ route('seller.employee.store') }}">
                        <i class="fas fa-plus-circle"></i> Neuen Mitarbeiter erstellen
                    </a>
                </div>

                <div id="sellerEmployeesTableHolder">
                    @include('redesign.back.metronic.employees.pieces.table_fake')
                </div>
            @endif
        </div>
    </div>
@endsection

@section('scripts-page')
    <script src="{{ asset('metronic/vendors/custom/datatables/datatables.bundle.js') }}" type="text/javascript"></script>

    @if( $employees->count() )

        <script>
            $(document).ready(function() {
                var dt = $('#sellerEmployeesTable').DataTable({
                    order: [],
                    autoWidth: false,
                    dom: '<"col-12"t><"col-12"<"row"<"col-12 col-sm-6 col-xl-4 text-center text-sm-left"l><"col-12 col-sm-6 col-xl-4 text-center text-sm-right text-xl-center"i><"col-12 col-xl-4 text-right"p>>>',
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, 'Alle']],
                    language: {
                        url: '{{ asset('js/plugins/dataTables/i18n/German.json') }}',
                    },
                    responsive: {
                        details: false,
                    },
                    columns: [
                        { responsivePriority: 1 },
                        { responsivePriority: 2 },
                        { responsivePriority: 7 },
                        { responsivePriority: 6 },
                        { responsivePriority: 5 },
                        { responsivePriority: 4 },
                        { responsivePriority: 3 },
                        { responsivePriority: -2, orderable: false },
                    ],
                });

                $('#employeeSearchInput').on('change keyup', function () {
                    var s = $(this).val().trim();
                    s = s.replace(/\s/g, '');
                    dt.search(s).draw();
                });

                $('#employeeSearchReset').on('click', function () {
                    $('#employeeSearchInput').val('').change();
                });

                $('#sellerEmployeesTableHolder').removeClass('d-none');

                var url = new URL(window.location.href);
                var s = url.searchParams.get('s');

                if (null !== s) {
                    $('#employeeSearchInput').val(s).change();
                }

                $('.employeeDeleteBtn').on('click', function (e) {
                    e.preventDefault();
                    e.stopPropagation();

                    swal.fire({
                        title: 'Bist Du sicher?',
                        text: 'Aktion ist nicht kündbar',
                        type: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Ja',
                        cancelButtonText: 'Nein',
                        focusConfirm: false,
                        focusCancel: true,
                        heightAuto: false,
                    }).then((result) => {
                        if (result.value) {
                            $('#employeeDeleteForm')
                                .attr('action', $(this).attr('href'))
                                .submit();
                        }
                    });
                });

                var prepareLog = function (list) {
                    var html = '';

                    for (i in list) {
                        html +=
                            '<div class="kt-timeline-v2__item d-none">' +
                                '<span class="kt-timeline-v2__item-time">' + list[i].date + '</span>' +
                                    '<div class="kt-timeline-v2__item-cricle">' +
                                        '<i class="fa fa-genderless kt-font-info"></i>' +
                                    '</div>' +
                                '<div class="kt-timeline-v2__item-text kt-padding-top-5">' + list[i].action + '</div>' +
                            '</div>';
                    }

                    $('#employeeLogModalItemList').html(html);

                    setTimeout(function () {
                        $('#employeeLogModalItemList .kt-timeline-v2__item.d-none').slice(0, 10).removeClass('d-none');
                    }, 25);

                    if (list.length > 10) {
                        $('#employeeLogModalShowMore').show();
                    } else {
                        $('#employeeLogModalShowMore').hide();
                    }
                };

                var showLog = function (id) {
                    $('#overlay').show();

                    $.ajax('/api/activity/' + id + '/get/', {
                        type: 'post',
                        dataType: 'json',
                        success: function (response) {
                            $('#employeeLogModalDetails').attr('href', '/dashboard/employees/activity?employee=' + id);
                            prepareLog(response.success);
                            setTimeout(function () {
                                $('#employeeLogModal').modal('show');
                            }, 50);
                        },
                        error: function (error) {
                            $('#overlay').hide();
                            swal.fire('Fehler', 'Es ist ein unbekannter Fehler aufgetreten', 'error');
                        },
                    });

                };

                var resendLink = function (id) {
                    $('#overlay').show();

                    $.ajax('/api/employee/' + id + '/sendlink/', {
                        type: 'post',
                        dataType: 'json',
                        success: function (response) {
                            $('#overlay').hide();
                            swal.fire('Erfolg', 'Wir haben eine Bestätigungsmail mit einem Link gesendet', 'success');
                        },
                        error: function (error) {
                            $('#overlay').hide();
                            swal.fire('Fehler', 'Es ist ein unbekannter Fehler aufgetreten', 'error');
                        },
                    });
                };

                $('.employeeShowLog').on('click', function (e) {
                    e.preventDefault();
                    e.stopPropagation();

                    showLog($(this).attr('data-id'));
                });

                $('#employeeLogModalShowMore').on('click', function () {
                    $('#employeeLogModalItemList .kt-timeline-v2__item.d-none').slice(0, 10).removeClass('d-none');

                    if ( !$('#employeeLogModalItemList .kt-timeline-v2__item.d-none').length ) {
                        $(this).hide();
                    }
                });

                $('.employeeLinkResendBtn').on('click', function (e) {
                    e.preventDefault();
                    e.stopPropagation();

                    resendLink($(this).attr('data-id'));
                });

                $('#overlay').hide();
            });
        </script>

    @else

        <script>
            $(document).ready(function() {
                var dt = $('#sellerEmployeesTable').DataTable({
                    paging: false,
                    info: false,
                    searching: false,
                    autoWidth: false,
                    dom: 't',
                    order: [[ 0, 'asc' ]],
                    language: {
                        url: '{{ asset('js/plugins/dataTables/i18n/German.json') }}',
                    },
                    responsive: {
                        details: false,
                    },
                    columns: [
                        { responsivePriority: 1 },
                        { responsivePriority: 2 },
                        { responsivePriority: 7 },
                        { responsivePriority: 6 },
                        { responsivePriority: 5 },
                        { responsivePriority: 4 },
                        { responsivePriority: 3 },
                        { responsivePriority: -2, orderable: false },
                    ],
                });

                $('#overlay').hide();
            });
        </script>

    @endif
@endsection