@extends('redesign.layouts.metronic.dashboard')

@section('title', 'Mitarbeiter Aktivität')

@section('documentTitle', 'Mitarbeiter Aktivität')

@section('styles-page')
    <link href="{{ asset('metronic/vendors/general/bootstrap-select/dist/css/bootstrap-select.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('metronic/vendors/general/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('document')
    <div class="kt-portlet kt-portlet--mobile">
        <div class="kt-portlet__head kt-portlet__head--lg">
            <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon">
                    <i class="fas fa-ticket-alt"></i>
                </span>
                <h3 class="kt-portlet__head-title">
                    Mitarbeiter Aktivität
                </h3>
            </div>
        </div>

        <div class="kt-portlet__body">
            @if( $employees->count() )
                @include('redesign.back.metronic.employees.pieces.activity.filters')

                <div class="kt-separator kt-separator--border-dashed kt-separator--space-md"></div>

                @include('redesign.back.metronic.employees.pieces.activity.results')
            @else
                <div class="pt-5 pb-5 text-center">
                    <h2 class="mb-4">Noch keine Mitarbeiter.</h2>
                    <a class="btn btn-primary" href="{{ route('seller.employee.store') }}">
                        <i class="fas fa-plus-circle"></i> Neuen Mitarbeiter erstellen
                    </a>
                </div>
            @endif
        </div>
    </div>
@endsection

@section('scripts-page')
    @if( $employees->count() )

    <script src="{{ asset('metronic/vendors/general/bootstrap-select/dist/js/bootstrap-select.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/bootstrap-select/dist/js/i18n/defaults-de_DE.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/bootstrap-daterangepicker/daterangepicker.js') }}" type="text/javascript"></script>

    <script>
        $(document).ready(function() {
            $("#uaEmployeesSelect").html($("#uaEmployeesSelect option").sort(function (a, b) {
                return a.text == b.text ? 0 : a.text < b.text ? -1 : 1
            }));

            $("#uaActionsSelect").html($("#uaActionsSelect option").sort(function (a, b) {
                return a.text == b.text ? 0 : a.text < b.text ? -1 : 1
            }));

            $('.kt-selectpicker').selectpicker({
                actionsBox: true,
            });

            $('#uaDates').daterangepicker({
                startDate: '{{ $minDate }}',
                endDate: '{{ $maxDate }}',
                minDate: '{{ $minDate }}',
                maxDate: '{{ $maxDate }}',
                "locale": {
                    "format": "DD.MM.YYYY",
                    "separator": " - ",
                    "applyLabel": "Anwenden",
                    "cancelLabel": "Schließen",
                    "fromLabel": "Von",
                    "toLabel": "Bis",
                    "daysOfWeek": ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
                    "monthNames": ["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"],
                    "firstDay": 1
                }
            });

            var uaGet = function (url, onSuccess) {
                $('#overlay').show();

                $.ajax(url, {
                    type: 'post',
                    dataType: 'json',
                    data: {
                        users: $('#uaEmployeesSelect').val(),
                        actions: $('#uaActionsSelect').val(),
                        minDate: $('#uaDates').data('daterangepicker').startDate.format('YYYY-MM-DD'),
                        maxDate: $('#uaDates').data('daterangepicker').endDate.format('YYYY-MM-DD'),
                    },
                    success: function (response) {
                        onSuccess(response.success);
                        $('#overlay').hide();
                    },
                    error: function (error) {
                        $('#overlay').hide();
                        swal.fire('Fehler', 'Es ist ein unbekannter Fehler aufgetreten', 'error');
                    },
                });
            };

            var uaInitEmployee = function () {
                var url = new URL(window.location.href);
                var eid = url.searchParams.get('employee');

                if (null !== eid) {
                    $('#uaEmployeesSelect').selectpicker('val', eid);
                    $('#uaApplyFilter').click();
                }
            };

            $('#uaApplyFilter').on('click', function () {
                uaGet('/api/activity/get/', function (response) {
                    $('#uaResultsHolder').removeClass('d-none').html(response);
                });
            });

            $(document).on('click', '.uaLoadMore', function () {
                var btn = $(this);
                var page = btn.data('page');

                uaGet('/api/activity/get/?page=' + page, function (response) {
                    $('#uaResults').append(response);
                    btn.parent().remove();
                });
            });

            uaInitEmployee();
        });
    </script>

    @endif
@endsection