<tr data-search="{{ $deal->searchString }}">
    <td>[id={{ $deal->id }}]</td>
    <td class="align-middle">
        <span class="deal-title" title="{{ $deal->title }}" data-toggle="kt-tooltip" data-title="{{ $deal->title }}">
            @include('redesign.back.metronic.pieces.img_card', [
                'img' => $deal->mainImage,
                'title' => $deal->title,
            ])
        </span>
    </td>
    <td class="align-middle" data-order="{{ $deal->discount_consumer }}">{{ $deal->present()->discount_consumer }}</td>
    <td class="align-middle" data-order="{{ $deal->provision_agent }}">{{ $deal->present()->provision_agent }}</td>
    <td class="align-middle">{{ $deal->coupons_count }}</td>
    <td class="align-middle">{{ $deal->quota - $deal->coupons_count }}</td>
    <td class="align-middle">{{ $deal->coupons_redeemed_count }}</td>
    <td class="align-middle">{{ $deal->present()->status_metronic }}</td>
    <td class="align-middle">
        <span class="dropdown">
            <a href="#" class="btn btn-sm btn-clean btn-icon btn-icon-md" data-toggle="dropdown" aria-expanded="false">
                <i class="fas fa-ellipsis-h"></i>
            </a>

            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end">
                <div class="dropdown-item showItemInfo" style="cursor:pointer" data-mid="d{{ $deal->id }}"><i class="fas fa-info"></i> Information</div>

                @if ( $user->canDo('edit deals', true) )
                    @if(App\CouponTemplate::STATUS_ACTIVE === $deal->status)
                        <a class="dropdown-item" href="{{ route('seller.deal.deactivate', $deal) }}"><i class="fas fa-toggle-off"></i> Deaktivieren</a>
                    @else
                        <a class="dropdown-item" href="{{ route('seller.deal.activate', $deal) }}"><i class="fas fa-toggle-on"></i> Aktivieren</a>
                    @endif
                    <a class="dropdown-item" href="{{ route('seller.deal.edit', $deal) }}"><i class="fas fa-pencil-alt"></i> Bearbeiten</a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item dealDeleteBtn" href="{{ route('seller.deal.delete', $deal) }}"><i class="fas fa-trash"></i> Löschen</a>
                @endif
            </div>
        </span>
    </td>
</tr>