<div class="cs-wizard__content dcStep" id="dcStepCategory">
    <div class="kt-heading kt-heading--md">Wähle die passende Kategorie für Deine Kampagne aus um besser gefunden werden</div>
    <div class="kt-form__section kt-form__section--first">
        <div class="cs-wizard__form">
            <div class="form-group" id="dcSelectedCategoryHolder" style="@if(!$deal->category) display: none @endif">
                <div class="alert alert-success" role="alert">
                    <div class="alert-icon"><i class="fas fa-check"></i></div>
                    <div class="alert-text">
                        Ausgewählte Kategorie:
                        <span id="dcSelectedCategoryPath">{{ $deal->category ? $deal->category->parentChain . ' / ' : '' }}</span>
                        <span id="dcSelectedCategoryName">{{ $deal->category ? $deal->category->name : '' }}</span>
                    </div>
                </div>
            </div>

            <div class="form-group inputHolder d-none" id="dcCatErrorAlert">
                <div class="alert alert-danger" role="alert">
                    <div class="alert-icon"><i class="fas fa-exclamation-triangle"></i></div>
                    <div class="alert-text invalid-feedback" data-name="category_id"></div>
                </div>
            </div>

            <div class="form-group inputHolder">
                <label for="dcCatSearchInput">Kategorie suche</label>
                <div class="input-group">
                    <input type="search" class="form-control" id="dcCatSearchInput" placeholder="Beginne zu suchen">
                    <div class="input-group-append">
                        <button class="btn btn-outline-secondary" type="button" id="dcCatSearchReset">
                            <i class="fas fa-ban"></i> Zurücksetzen
                        </button>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div id="dcCatListHolder">
                    <div id="dcCatList">
                        @foreach($categories as $node)
                            <div class="dcCatWrapper">
                                @include('redesign.back.metronic.deals.pieces.constructor.category', $node)
                            </div>
                        @endforeach
                    </div>
                    <div id="dcCatNothingFound" style="display: none" class="mt-2">
                        <div class="alert alert-danger">Tut uns leid. Nichts gefunden.</div>
                    </div>
                </div>
            </div>

            @include('redesign.back.metronic.deals.pieces.constructor.step_nav', [
                'prevStep' => 'dcStepGeneral',
                'prevTitle' => 'Zurück',
                'nextStep' => 'dcStepCashback',
                'nextTitle' => 'Weiter',
            ])
        </div>
    </div>
</div>