@extends('redesign.layouts.metronic.dashboard')

@section('title', 'Kampagnen')

@section('documentTitle', 'Kampagnen')

@section('overlay-style', 'display:block')

@section('styles-page')
    <link href="{{ asset('metronic/vendors/custom/datatables/datatables.bundle.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('document')
    <div class="kt-portlet kt-portlet--mobile">
        <div class="kt-portlet__head kt-portlet__head--lg">
            <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon">
                    <i class="fas fa-handshake"></i>
                </span>
                <h3 class="kt-portlet__head-title">
                    Kampagnen
                </h3>
            </div>
            @if( $user->canDo('create deals', true) )
            <div class="kt-portlet__head-toolbar">
                <div class="kt-portlet__head-wrapper">
                    <div class="kt-portlet__head-actions">
                        <a href="{{ route('seller.deal.create') }}" class="btn btn-brand btn-elevate btn-icon-sm">
                            <i class="fas fa-plus-circle"></i> Neue Kampagne erstellen
                        </a>
                    </div>
                </div>
            </div>
            @endif
        </div>

        <div class="kt-portlet__body">
            @if( $deals->count() )
                <div class="row mb-4">
                    <div class="form-group col-12 inputHolder">
                        <label for="dcDealSearchInput">Kampagne suche</label>
                        <div class="input-group">
                            <input type="search" class="form-control" id="dealSearchInput" placeholder="Beginne zu suchen">
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary" type="button" id="dealSearchReset">
                                    <i class="fas fa-ban"></i> Zurücksetzen
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                @include('redesign.back.metronic.deals.pieces.table')

                <form action="" method="post" class="d-none" id="dealDeleteForm">
                    {{ csrf_field() }}
                    {{ method_field('DELETE') }}
                </form>
            @else
                <div class="pt-5 pb-5 text-center">
                    <h2 class="mb-4">Noch keine Kampagnen.</h2>
                    @if( $user->canDo('create deals', true) )
                    <a class="btn btn-primary" href="{{ route('seller.deal.create') }}">
                        <i class="fas fa-plus-circle"></i> Neue Kampagne erstellen
                    </a>
                    @endif
                </div>

                @include('redesign.back.metronic.deals.pieces.table_fake')
            @endif
        </div>
    </div>
@endsection

@section('scripts-page')
    <script src="{{ asset('metronic/vendors/custom/datatables/datatables.bundle.js') }}" type="text/javascript"></script>

    @if( $deals->count() )

        <script>
            $(document).ready(function() {
                var dt = $('#sellerDealsTable').DataTable({
                    autoWidth: false,
                    dom: '<"col-12"t><"col-12"<"row"<"col-12 col-sm-6 col-xl-4 text-center text-sm-left"l><"col-12 col-sm-6 col-xl-4 text-center text-sm-right text-xl-center"i><"col-12 col-xl-4 text-right"p>>>',
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, 'Alle']],
                    responsive: {
                        details: false,
                    },
                    order: [[ 0, 'asc' ]],
                    columns: [
                        { visible: false },
                        { responsivePriority: -1 },
                        { responsivePriority: 1 },
                        { responsivePriority: 2 },
                        { responsivePriority: 3 },
                        { responsivePriority: 4 },
                        { responsivePriority: 5 },
                        { responsivePriority: 0 },
                        { responsivePriority: -2, orderable: false },
                    ],
                });

                $('.dealDeleteBtn').on('click', function (e) {
                    e.preventDefault();
                    e.stopPropagation();

                    swal.fire({
                        title: 'Bist Du sicher?',
                        text: 'Aktion ist nicht kündbar',
                        type: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Ja',
                        cancelButtonText: 'Nein',
                        focusConfirm: false,
                        focusCancel: true,
                        heightAuto: false,
                    }).then((result) => {
                        if (result.value) {
                            $('#dealDeleteForm')
                                .attr('action', $(this).attr('href'))
                                .submit();
                        }
                    });
                });

                $('#dealSearchInput').on('change keyup', function () {
                    var s = $(this).val().trim();
                    s = s.replace(/\s/g, '');
                    dt.search(s).draw();
                });

                $('#dealSearchReset').on('click', function () {
                    $('#dealSearchInput').val('').change();
                });

                var url = new URL(window.location.href);
                var s = url.searchParams.get('s');

                if (null !== s) {
                    $('#dealSearchInput').val(s).change();
                }

                $('#overlay').hide();
            });
        </script>

    @else

        <script>
            $(document).ready(function() {
                $('#sellerDealsTable').DataTable({
                    paging: false,
                    info: false,
                    searching: false,
                    autoWidth: false,
                    dom: 't',
                    order: [[ 0, 'asc' ]],
                    responsive: {
                        details: false,
                    },
                    columns: [
                        { responsivePriority: -1 },
                        { responsivePriority: 1 },
                        { responsivePriority: 2 },
                        { responsivePriority: 3 },
                        { responsivePriority: 4 },
                        { responsivePriority: 5 },
                        { responsivePriority: 0 },
                        { responsivePriority: -2, orderable: false },
                    ],
                });

                $('#overlay').hide();
            });
        </script>

    @endif
@endsection