@extends('redesign.layouts.metronic.dashboard')

@section('title', $title)

@section('documentTitle', $title)

@section('overlay-style', 'display:block')

@section('styles-page')
    <link rel="stylesheet" href="{{ asset('css/plugins/nouislider/nouislider.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins/bootstrap/jquery.bootstrap-touchspin.min.css') }}">
    <link href="{{ asset('metronic/css/styles/constructor.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('document')
    <div class="kt-portlet">
        <div class="kt-portlet__body kt-portlet__body--fit">
            <div class="kt-grid cs-wizard cs-wizard--white" id="kt_wizard_v3" data-ktwizard-state="first">
                <div class="kt-grid__item">

                    @include('redesign.back.metronic.deals.pieces.constructor.nav')

                    <div class="kt-grid__item kt-grid__item--fluid cs-wizard__wrapper">
                        <form class="kt-form" id="kt_form" novalidate="novalidate">
                            @include('redesign.back.metronic.deals.pieces.constructor.steps.general')
                            @include('redesign.back.metronic.deals.pieces.constructor.steps.category')
                            @include('redesign.back.metronic.deals.pieces.constructor.steps.cashback')
                            @include('redesign.back.metronic.deals.pieces.constructor.steps.recocash')
                            @include('redesign.back.metronic.deals.pieces.constructor.steps.places')
                            @include('redesign.back.metronic.deals.pieces.constructor.steps.gallery')

                            @if ( !$deal->isDraft() )
                                @include('redesign.back.metronic.deals.pieces.constructor.actions')
                            @endif

                            <input type="hidden" id="dcRedirect" value="{{ route('seller.deals.index') }}">
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('redesign.back.metronic.deals.pieces.constructor.image_preview')
    @include('redesign.back.metronic.deals.pieces.constructor.deal_preview')
@endsection

@section('scripts-page')
    <script src="{{ asset('js/plugins/nouislider/nouislider.min.js') }}"></script>
    <script src="{{ asset('js/plugins/bootstrap/jquery.bootstrap-touchspin.min.js') }}"></script>
    <script src="{{ asset('js/plugins/cleave/cleave.min.js') }}"></script>
    <script src="{{ asset('js/plugins/mask/jquery.mask.js') }}"></script>
    <script src="{{ asset('js/plugins/mark/jquery.mark.min.js') }}"></script>
    <script src="{{ asset('js/plugins/jquery-ui/sortable/jquery-ui.min.js') }}"></script>
    <script src="{{ asset('js/plugins/jqueryfileupload/vendor/jquery.ui.widget.js') }}"></script>
    <script src="{{ asset('js/plugins/jqueryfileupload/jquery.iframe-transport.js') }}"></script>
    <script src="{{ asset('js/plugins/jqueryfileupload/jquery.fileupload.js') }}"></script>
    <script src="{{ asset('js/plugins/jqueryfileupload/jquery.fileupload-process.js') }}"></script>
    <script src="{{ asset('js/plugins/jqueryfileupload/jquery.fileupload-validate.js') }}"></script>
    <script src="{{ asset('metronic/js/scripts/constructor.js') }}"></script>
    <script>
        var dealId = {{ $deal->id }};
        var draft = {{ $deal->isDraft() ? 'true' : 'false' }};
    </script>
@endsection