<div class="kt-portlet kt-portlet--bordered-semi kt-portlet--space kt-portlet--height-fluid">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h3 class="kt-portlet__head-title">
                Bewertungen
                @if( $reviewsCount )
                    <small>
                        @include('redesign.back.metronic.pieces.rating', ['rating' => $reviewsAvg])
                        &Oslash; {{ $reviewsAvg }} aus {{ $reviewsCount }} Bewertungen
                    </small>
                @endif
            </h3>
        </div>
        <div class="kt-portlet__head-toolbar">
            <div class="dropdown dropdown-inline">
                <button type="button" class="btn btn-clean btn-sm btn-icon btn-icon-lg" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-h"></i>
                </button>
                <div class="dropdown-menu dropdown-menu-right">
                    <ul class="kt-nav">
                        <li class="kt-nav__item">
                            <a href="{{ route('seller.reviews.index') }}" class="kt-nav__link">
                                <span class="kt-nav__link-text"><i class="fas fa-list-ul"></i>&nbsp;&nbsp;Alle ansehen</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="kt-portlet__body">
        @if( $reviewsCount )
            <div class="tab-content">
                <div class="tab-pane active" id="kt_widget31_tab1_content">
                    <div class="kt-widget31">
                        @foreach($reviewsCounts as $k => $v)
                            <div class="kt-widget31__item">
                                <div class="kt-widget31__content">
                                    <div class="kt-widget31__progress">
                                        <span class="kt-widget31__stats">
                                            <span>@include('redesign.back.metronic.pieces.rating', ['rating' => $k, 'classes' => 'dashboard'])</span>
                                            <span>{{ round($v / $reviewsCount * 100) }}%</span>
                                        </span>
                                        <div class="progress progress-sm">
                                            <div class="progress-bar bg-brand" role="progressbar" style="width: {{ round($v / $reviewsCount * 100) }}%" aria-valuenow="{{ round($v / $reviewsCount * 100) }}" aria-valuemin="0" aria-valuemax="100"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @else
            <div class="text-center pb-5 pt-5">
                <h4 class="mb-4">Noch keine Bewertungen vorhanden.</h4>
            </div>
        @endif
    </div>
</div>