<div class="kt-portlet kt-portlet--bordered-semi kt-portlet--space kt-portlet--height-fluid">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h3 class="kt-portlet__head-title">
                Kampagnen
            </h3>
        </div>
        <div class="kt-portlet__head-toolbar">
            <div class="dropdown dropdown-inline">
                <button type="button" class="btn btn-clean btn-sm btn-icon btn-icon-lg" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-h"></i>
                </button>
                <div class="dropdown-menu dropdown-menu-right">
                    <ul class="kt-nav">
                        <li class="kt-nav__item">
                            <a href="{{ route('seller.deals.index') }}" class="kt-nav__link">
                                <span class="kt-nav__link-text"><i class="fas fa-list-ul"></i>&nbsp;&nbsp;Alle ansehen</span>
                            </a>
                        </li>

                        @if( $user->canDo('create deals', true) )
                        <li class="kt-nav__item">
                            <a href="{{ route('seller.deal.create') }}" class="kt-nav__link">
                                <span class="kt-nav__link-text"><i class="fas fa-plus-circle"></i>&nbsp;&nbsp;Neue erstellen</span>
                            </a>
                        </li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="kt-portlet__body">
        @if( $deals->count() )
            <div class="kt-widget14">
                <div class="kt-widget14__content">
                    <div class="kt-widget14__chart">
                        <div id="dealsChart" style="height: 150px; width: 150px;"></div>
                    </div>
                    <div class="kt-widget14__legends">
                        <div class="kt-widget14__legend">
                            <span class="kt-widget14__bullet kt-bg-success"></span>
                            <span class="kt-widget14__stats">{{ isset($deals['active']) ? $deals['active']->count() : 0 }} Aktiv</span>
                        </div>
                        <div class="kt-widget14__legend">
                            <span class="kt-widget14__bullet kt-bg-danger"></span>
                            <span class="kt-widget14__stats">{{ isset($deals['inactive']) ? $deals['inactive']->count() : 0 }} Inaktiv</span>
                        </div>
                    </div>
                </div>
            </div>
        @else
            <div class="text-center pb-5 pt-5">
                <h4 class="mb-4">Noch keine Kampagnen.</h4>

                @if( $user->canDo('create deals', true) )
                <a class="btn btn-primary" href="{{ route('seller.deal.create') }}">
                    <i class="fas fa-plus-circle"></i> Neue Kampagne erstellen
                </a>
                @endif
            </div>
        @endif
    </div>
</div>