<div class="kt-portlet kt-portlet--bordered-semi kt-portlet--space kt-portlet--height-fluid">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h3 class="kt-portlet__head-title">
                Empfehlungen
            </h3>
        </div>
        <div class="kt-portlet__head-toolbar">
            <div class="dropdown dropdown-inline">
                <button type="button" class="btn btn-clean btn-sm btn-icon btn-icon-lg" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-h"></i>
                </button>
                <div class="dropdown-menu dropdown-menu-right">
                    <ul class="kt-nav">
                        <li class="kt-nav__item">
                            <a href="{{ route('seller.coupons.index') }}" class="kt-nav__link">
                                <span class="kt-nav__link-text"><i class="fas fa-list-ul"></i>&nbsp;&nbsp;Alle ansehen</span>
                            </a>
                        </li>
                        @if( $user->canDo('redeem coupons', true) )
                        <li class="kt-nav__item">
                            <a href="{{ route('seller.coupon.redeeming.index') }}" class="kt-nav__link">
                                <span class="kt-nav__link-text"><i class="fas fa-barcode"></i>&nbsp;&nbsp;Einlösen</span>
                            </a>
                        </li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="kt-portlet__body">
        @if( $coupons->count() )
            <div class="kt-widget14">
                <div class="kt-widget14__content">
                    <div class="kt-widget14__chart">
                        <div id="couponsChart" style="height: 150px; width: 150px;"></div>
                    </div>
                    <div class="kt-widget14__legends">
                        <div class="kt-widget14__legend">
                            <span class="kt-widget14__bullet kt-bg-dark"></span>
                            <span class="kt-widget14__stats">{{ isset($coupons['active']) ? $coupons['active']->count() : 0 }} Empfohlen</span>
                        </div>
                        <div class="kt-widget14__legend">
                            <span class="kt-widget14__bullet kt-bg-warning"></span>
                            <span class="kt-widget14__stats">{{ isset($coupons['redeemed']) ? $coupons['redeemed']->count() : 0 }} Eingelöst</span>
                        </div>
                        <div class="kt-widget14__legend">
                            <span class="kt-widget14__bullet kt-bg-info"></span>
                            <span class="kt-widget14__stats">{{ isset($coupons['paid']) ? $coupons['paid']->count() : 0 }} Bezahlt</span>
                        </div>
                        <div class="kt-widget14__legend">
                            <span class="kt-widget14__bullet kt-bg-success"></span>
                            <span class="kt-widget14__stats">{{ isset($coupons['done']) ? $coupons['done']->count() : 0 }} Abgeschlossen</span>
                        </div>
                    </div>
                </div>
            </div>
        @else
            <div class="text-center pb-5 pt-5">
                <h4 class="mb-4">Noch keine empfohlenen BONS.</h4>
            </div>
        @endif
    </div>
</div>