<script>
    $(document).ready(function () {
        var chart = new Morris.Area({
            parseTime: false,
            resize: true,
            redraw: true,
            element: 'activatedCouponsChart',
            data: [
                @foreach($activatedCoupons as $group)
                {
                    x: '{{ $group->period }}',
                    @foreach($group->values as $item)
                        {{ $item->key }}: {{ $item->value }},
                    @endforeach
                },
                @endforeach
            ],
            xkey: 'x',
            ykeys: [
                @foreach($activatedCoupons->first()->values as $item)
                    '{{ $item->key }}',
                @endforeach
            ],
            labels: [
                @foreach($activatedCoupons->first()->values as $item)
                    '{{ $item->name }}',
                @endforeach
            ],
        });

        $(window).resize(function () {
            chart.redraw();
        });
    });
</script>