@extends('redesign.layouts.metronic.dashboard')

@section('title', 'Seller Dashboard')

@section('documentTitle', 'Seller Dashboard')

@section('styles-page')
    <link href="{{ asset('metronic/vendors/general/morris.js/morris.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('metronic/css/styles/redeem.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('document')
    @if( !$user->email_verified )
        <div class="alert alert-warning">
            <div class="alert-icon"><i class="fas fa-exclamation-triangle"></i></div>
            <div class="alert-text">
                Bitte bestätige Deine E-Mail. Wir haben eine Bestätigungsmail mit einem Link an <strong>{{ $user->email_temp ? $user->email_temp : $user->email }}</strong> gesendet.
                <br>
                Sollte die E-Mail nicht angekommen sein bitte <a href="#" class="alert-link" id="emailVerificationSend">hier klicken</a>.
            </div>
        </div>
    @endif

    <div class="row">
        @if( $user->canDo('view deals', true) )
        <div class="col-md-6">
            @include('redesign.back.metronic.dashboard.pieces.deals')
        </div>
        @endif

        @if( $user->canDo('view coupons', true) )
        <div class="col-md-6">
            @include('redesign.back.metronic.dashboard.pieces.coupons')
        </div>
        @endif

        @if( $user->canDo('view transactions', true) )
        <div class="col-md-6">
            @include('redesign.back.metronic.dashboard.pieces.billing')
        </div>
        @endif

        @if( $user->canDo('view reviews', true) )
        <div class="col-md-6">
            @include('redesign.back.metronic.dashboard.pieces.reviews')
        </div>
        @endif

        @if( $user->canDo('view deals', true) )
        <div class="col-md-6">
            @include('redesign.back.metronic.dashboard.pieces.activated_coupons')
        </div>
        @endif

        @if( $user->canDo('redeem coupons', true) )
        <div class="col-md-6">
            @include('redesign.back.metronic.dashboard.pieces.redeem')
        </div>
        @endif
    </div>

    @include('redesign.back.metronic.coupons.pieces.redeem.scanner')
@endsection

@section('scripts-page')
    <script src="{{ asset('js/plugins/cleave/cleave.min.js') }}"></script>
    <script src="{{ asset('js/plugins/mask/jquery.mask.js') }}"></script>
    <script src="{{ asset('js/plugins/instascan/instascan.min.js') }}"></script>
    <script src="{{ asset('metronic/js/scripts/redeeming.js') }}"></script>
    <script src="{{ asset('metronic/vendors/general/raphael/raphael.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/morris.js/morris.js') }}" type="text/javascript"></script>

    @if( $deals->count() )
        @include('redesign.back.metronic.dashboard.pieces.deals_chart')
    @endif

    @if( $coupons->count() )
        @include('redesign.back.metronic.dashboard.pieces.coupons_chart')
    @endif

    @if( $activatedCoupons->count() )
        @include('redesign.back.metronic.dashboard.pieces.activated_coupons_chart')
    @endif
@endsection