@extends('redesign.layouts.metronic.dashboard')

@section('title', 'RECO.BON einlösen')

@section('documentTitle', 'RECO.BON einlösen')

@section('overlay-style', 'display:block')

@section('styles-page')
    <link href="{{ asset('metronic/css/styles/redeem.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('document')
    @if( !$seller->hasPaymentType() )
        <div class="alert alert-warning">
            <div class="alert-icon"><i class="fas fa-exclamation-triangle"></i></div>
            <div class="alert-text">
                Du hast keine Zahlungsdaten.
                <a class="alert-link" href="{{ route('seller.company.index') . '#bank' }}">Jetzt einstellen</a>
            </div>
        </div>
    @endif

    @if( !$seller->email_verified )
        <div class="alert alert-warning">
            <div class="alert-icon"><i class="fas fa-exclamation-triangle"></i></div>
            <div class="alert-text">
                Bitte bestätige Deine E-Mail. Wir haben eine Bestätigungsmail mit einem Link an <strong>{{ $seller->email_temp ? $seller->email_temp : $seller->email }}</strong> gesendet.
                <br>
                Sollte die E-Mail nicht angekommen sein bitte <a href="#" class="alert-link" id="emailVerificationSend">hier klicken</a>.
            </div>
        </div>
    @endif

    <div class="kt-portlet">
        <div class="kt-portlet__body kt-portlet__body--fit">
            <div class="kt-grid cs-wizard cs-wizard--white" id="kt_wizard_v3" data-ktwizard-state="first">
                <div class="kt-grid__item">

                    @include('redesign.back.metronic.coupons.pieces.redeem.nav')

                    <div class="kt-grid__item kt-grid__item--fluid cs-wizard__wrapper">
                        <form class="kt-form" id="rdForm" novalidate="novalidate" @if( !$seller->hasPaymentType() || !$seller->email_verified ) style="opacity: 0.5" @endif>
                            @include('redesign.back.metronic.coupons.pieces.redeem.steps.code')
                            @include('redesign.back.metronic.coupons.pieces.redeem.steps.details')
                            @include('redesign.back.metronic.coupons.pieces.redeem.steps.payment')
                            @include('redesign.back.metronic.coupons.pieces.redeem.steps.summary')

                            @if( !$seller->hasPaymentType() || !$seller->email_verified )
                                <div id="rdFormOverlay"></div>
                            @endif

                            <input type="hidden" id="rdRedirect" value="{{ ( url()->previous() !== url()->current() ) ? url()->previous() : route('home') }}" />
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('redesign.back.metronic.coupons.pieces.redeem.scanner')
@endsection

@section('scripts-page')
    <script src="{{ asset('js/plugins/cleave/cleave.min.js') }}"></script>
    <script src="{{ asset('js/plugins/mask/jquery.mask.js') }}"></script>
    <script src="{{ asset('js/plugins/instascan/instascan.min.js') }}"></script>
    <script src="{{ asset('metronic/js/scripts/redeeming.js') }}"></script>
@endsection