<div class="modal" tabindex="-1" role="dialog" id="c{{ $coupon->id }}">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ $coupon->present()->code  }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table table-striped table-borderless">
                    <thead>
                    </thead>
                    <tbody>
                    <tr>
                        <td>RECO.CODE</td>
                        <td><span class="text-monospace">{{ $coupon->present()->code }}</span></td>
                    </tr>
                    <tr>
                        <td>Kampagne</td>
                        <td>
                            <span class="sellerDealTitle" title="{{ $coupon->template->title }}">
                                @include('redesign.back.metronic.pieces.img_card', [
                                    'img' => $coupon->template->mainImage,
                                    'title' => $coupon->template->title,
                                ])
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td>Kunde</td>
                        <td>
                            @include('redesign.back.metronic.pieces.user_card', [
                                'img' => $coupon->consumer->userpic,
                                'title' => $coupon->consumer->fullname,
                            ])
                        </td>
                    </tr>
                    <tr>
                        <td>Empfehler</td>
                        <td>
                            @include('redesign.back.metronic.pieces.user_card', [
                                'img' => $coupon->agent->userpic,
                                'title' => $coupon->agent->fullname,
                            ])
                        </td>
                    </tr>
                    <tr>
                        <td>Warenkorb</td>
                        <td>{{ $coupon->present()->netto }}</td>
                    </tr>
                    <tr>
                        <td>Cashback</td>
                        <td>{{ $coupon->present()->discount_consumer }}</td>
                    </tr>
                    <tr>
                        <td>RECO.CASH</td>
                        <td>{{ $coupon->present()->provision_agent }}</td>
                    </tr>
                    <tr>
                        <td>Eingelöst</td>
                        <td>{{ $coupon->present()->redeem_date }}</td>
                    </tr>
                    <tr>
                        <td>Status</td>
                        <td>{{ $coupon->present()->status_metronic }}</td>
                    </tr>
                    <tr>
                        <td>Erlöser</td>
                        <td>
                            @if( $coupon->redeemer )
                                @include('redesign.back.metronic.pieces.user_card', [
                                    'img' => $coupon->redeemer->userpic,
                                    'title' => $coupon->redeemer->fullname,
                                ])
                            @endif
                        </td>
                    </tr>

                    @if( $user->canDo('redeem coupons', true) && App\Coupon::STATUS_ACTIVE === $coupon->status )
                        <tr>
                            <td colspan="2" class="text-center">
                                <a href="{{ route('seller.coupon.redeeming.index') . '?code=' . $coupon->code }}" class="btn btn-primary">
                                    <i class="fas fa-barcode"></i> RECO.BON einlösen
                                </a>
                            </td>
                        </tr>
                    @endif

                    @if( $user->canDo('redeem coupons', true) && in_array($coupon->status, App\Coupon::STATUS_GROUP_CAN_BE_MARKED_PAID) )
                        <tr>
                            <td colspan="2" class="text-center">
                                <div class="btn btn-warning sellerSetCouponPaid" data-coupon-id="{{ $coupon->id }}">
                                    <i class="fas fa-euro-sign"></i> Zahlung erhalten
                                </div>
                            </td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Schließen</button>
            </div>
        </div>
    </div>
</div>