@extends('redesign.layouts.metronic.dashboard')

@section('title', 'Meine Empfehlungen')

@section('documentTitle', 'Meine Empfehlungen')

@section('overlay-style', 'display:block')

@section('styles-page')
    <link href="{{ asset('metronic/vendors/custom/datatables/datatables.bundle.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('document')
    <div class="kt-portlet kt-portlet--mobile">
        <div class="kt-portlet__head kt-portlet__head--lg">
            <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon">
                    <i class="fas fa-ticket-alt"></i>
                </span>
                <h3 class="kt-portlet__head-title">
                    Meine Empfehlungen
                </h3>
            </div>

            @if( $user->canDo('redeem coupons', true) )
            <div class="kt-portlet__head-toolbar">
                <div class="kt-portlet__head-wrapper">
                    <div class="kt-portlet__head-actions">
                        <a href="{{ route('seller.coupon.redeeming.index') }}" class="btn btn-brand btn-elevate btn-icon-sm">
                            <i class="fas fa-barcode"></i> RECO.BON einlösen
                        </a>
                    </div>
                </div>
            </div>
            @endif
        </div>

        <div class="kt-portlet__body">
            @if( $coupons->count() )
                <div class="mb-4">
                    <div class="form-group col-12 inputHolder">
                        <label for="couponSearchInput">RECO.BON suche</label>
                        <div class="input-group">
                            <input type="search" class="form-control" id="couponSearchInput" placeholder="Beginne zu suchen">
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary" type="button" id="couponSearchReset">
                                    <i class="fas fa-ban"></i> Zurücksetzen
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="sellerCouponsTableHolder" class="d-none">
                    @include('redesign.back.metronic.coupons.pieces.table')
                </div>
            @else
                <div class="pt-5 pb-5 text-center">
                    <h2 class="mb-4">Noch keine empfohlenen BONS.</h2>
                    <a class="btn btn-primary" href="{{ route('home') }}">
                        <i class="fas fa-tachometer-alt"></i> Zum Dashboard
                    </a>
                </div>

                <div id="sellerCouponsTableHolder">
                    @include('redesign.back.metronic.coupons.pieces.table_fake')
                </div>
            @endif
        </div>
    </div>
@endsection

@section('scripts-page')
    <script src="{{ asset('metronic/vendors/custom/datatables/datatables.bundle.js') }}" type="text/javascript"></script>

    @if( $coupons->count() )

        <script>
            $(document).ready(function() {
                var dt = $('#sellerCouponsTable').DataTable({
                    order: [],
                    autoWidth: false,
                    dom: '<"col-12"t><"col-12"<"row"<"col-12 col-sm-6 col-xl-4 text-center text-sm-left"l><"col-12 col-sm-6 col-xl-4 text-center text-sm-right text-xl-center"i><"col-12 col-xl-4 text-right"p>>>',
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, 'Alle']],
                    responsive: {
                        details: false,
                    },
                    columns: [
                        { responsivePriority: -1 },
                        { responsivePriority: 6 },
                        { responsivePriority: 8 },
                        { responsivePriority: 7 },
                        { responsivePriority: 4 },
                        { responsivePriority: 2 },
                        { responsivePriority: 3 },
                        { responsivePriority: 5 },
                        { responsivePriority: 9 },
                        { responsivePriority: 1 },
                        { responsivePriority: -2, orderable: false },
                    ],
                    language: {
                        url: '{{ asset('js/plugins/dataTables/i18n/German.json') }}',
                    }
                });

                $('#couponSearchInput').on('change keyup', function () {
                    var s = $(this).val().trim();
                    s = s.replace(/\s/g, '');
                    dt.search(s).draw();
                });

                $('#couponSearchReset').on('click', function () {
                    $('#couponSearchInput').val('').change();
                });

                $('#sellerCouponsTableHolder').removeClass('d-none');

                var url = new URL(window.location.href);
                var s = url.searchParams.get('s');

                if (null !== s) {
                    $('#couponSearchInput').val(s).change();
                }

                $('#overlay').hide();
            });
        </script>

    @else

        <script>
            $(document).ready(function() {
                var dt = $('#sellerCouponsTable').DataTable({
                    paging: false,
                    info: false,
                    searching: false,
                    autoWidth: false,
                    dom: 't',
                    order: [[ 0, 'asc' ]],
                    responsive: {
                        details: false,
                    },
                    columns: [
                        { responsivePriority: -1 },
                        { responsivePriority: 6 },
                        { responsivePriority: 8 },
                        { responsivePriority: 7 },
                        { responsivePriority: 4 },
                        { responsivePriority: 2 },
                        { responsivePriority: 3 },
                        { responsivePriority: 5 },
                        { responsivePriority: 9 },
                        { responsivePriority: 1 },
                        { responsivePriority: -2, orderable: false },
                    ],
                    language: {
                        url: '{{ asset('js/plugins/dataTables/i18n/German.json') }}',
                    }
                });

                $('#overlay').hide();
            });
        </script>

    @endif
@endsection