@extends('redesign.layouts.auth')

@section('title', 'Registrieren')

@section('meta')
    <meta property="og:url" content="{{ Request::url() }}" />
    <meta property="og:type" content="website" />
    <meta property="fb:app_id" content="{{ config('services.facebook.app_id') }}" />
    @if ('invite-new-agent' === $linkInvitation->reason)
        <meta property="og:image" content="{{ url('/account/portraits/' . $linkInvitation->user->account->upload_portrait) }}" />
        <meta property="og:image:width" content="200" />
        <meta property="og:image:height" content="200" />
    @elseif(!is_null($linkInvitation->account))
        <meta property="og:image" content="{{ url('/account/portraits/' . $linkInvitation->account->upload_portrait) }}" />
        <meta property="og:image:width" content="200" />
        <meta property="og:image:height" content="200" />
        <meta property="og:title" content="Spare und erhalte Prozente nach Deinem Einkauf bei {!! $linkInvitation->account->getDisplayName() !!}" />
        <meta property="og:description" content="Spare und erhalte Prozente nach Deinem Einkauf bei {!! $linkInvitation->account->getDisplayName() !!}" />
    @else
        <meta property="og:image" content="{{ route('coupon.get-image', $linkInvitation->couponTemplate->img) }}" />
        <meta property="og:image:width" content="200" />
        <meta property="og:image:height" content="200" />
        <meta property="og:title" content="{{ $linkInvitation->couponTemplate->title }}" />
        <meta property="og:description" content="{{ $linkInvitation->couponTemplate->title }}" />
    @endif
@endsection

@section('form')
    <div class="card card-with-form">
        <div class="card-header bg-orange text-white text-center">
            @if ('invite-new-agent' === $linkInvitation->reason)
                <span><strong>{{ $linkInvitation->user->account->company }}</strong></span>
            @else
                @if(!empty($linkInvitation->user->upload_portrait))
                    <div>
                        <div class="d-inline-block" id="recommenderUserpic" style="background-image:url('/account/portraits/{{ $linkInvitation->user->upload_portrait }}')"></div>
                    </div>
                @endif
                <span>{{ $linkInvitation->user->fullname }} empfiehlt dir</span>
            @endif
        </div>
        <div class="card-body">
            @if ('invite-new-agent' === $linkInvitation->reason)
                <p class="text-center mt-3">
                    <img id="recommendedSellerLogo" src="/account/portraits/{{$linkInvitation->user->account->upload_portrait}}">
                </p>
            @elseif(!is_null($linkInvitation->account))
                <p class="text-center mt-3">
                    <img id="recommendedSellerLogo" src="/account/portraits/{{$linkInvitation->account->upload_portrait}}">
                </p>
                <p class="text-center">Spare und erhalte Prozente nach Deinem Einkauf</p>
                <p class="text-center">bei <strong>{!! $linkInvitation->account->getDisplayName() !!}</strong></p>
            @else
                <div class="text-center mt-2">
                    @include('redesign.front.pieces.deal.invite', ['deal' => $linkInvitation->couponTemplate])
                </div>
            @endif

            <form id="registerForm" action="{{ route('handle-easy-registration', ['token' => $linkInvitation->token]) }}" method="post">
                {{ csrf_field() }}

                <input type="hidden" name="form" value="auth_user_registration_invite">

                <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                    <input type="text"
                           name="email"
                           class="form-control mx-auto"
                           id="loginEmail"
                           placeholder="E-Mail Adresse"
                           value="{{ old('email') }}"
                    >
                    @include('redesign.pieces.form.error', ['property' => 'email'])
                </div>

                <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                    <input type="password"
                           name="password"
                           class="form-control mx-auto"
                           id="registerPassword"
                           placeholder="Passwort"
                    >
                    @include('redesign.pieces.form.error', ['property' => 'password'])
                </div>

                <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                    <input type="password"
                           name="password_confirmation"
                           class="form-control mx-auto"
                           id="registerPasswordConfirm"
                           placeholder="Passwort bestätigen"
                    >
                    @include('redesign.pieces.form.error', ['property' => 'password_confirmation'])
                </div>

                <div class="mt-4 mb-4 text-center">
                    <button type="submit" class="btn btn-primary">Jetzt registrieren</button>
                </div>

                <div class="text-center fs-12 mb-4 mx-auto" style="max-width: 300px">
                    <div class="stepFooter">Durch die Registrierung erkennen Du die <a target="_blank" class="text-primary" href="{{ route('agb') }}">AGB</a> sowie die <a target="_blank" class="text-primary" href="{{ route('privacy') }}">Datenschutzbestimmungen</a> von RECO.MA an.</div>
                </div>
            </form>
        </div>
    </div>
@endsection