@extends('redesign.layouts.listeo.auth')

@section('title', 'Registrieren')

@section('meta')
    <meta property="og:url" content="{{ Request::fullUrl() }}" />
    <meta property="og:type" content="website" />
    <meta property="fb:app_id" content="{{ config('services.facebook.app_id') }}" />

    <meta property="og:image" content="{{ $meta->image }}" />
    <meta property="og:image:width" content="200" />
    <meta property="og:image:height" content="200" />
    <meta property="og:title" content="{{ $meta->title }}" />
    <meta property="og:description" content="{{ $meta->descr }}" />
@endsection

@if ( !$errors->any() && ((null !== $referrer && $referrer->hasRole('seller')) || null !== $seller || null !== $deal) )
    @section('body-classes', 'modal-open')
@endif

@section('landing')
    @if (null !== $referrer && $referrer->hasRole('seller'))
        @include('redesign.auth.pieces.landing_seller_shares_self', ['seller' => $referrer])
    @elseif (null !== $seller)
        @include('redesign.auth.pieces.landing_agent_shares_seller')
    @elseif (null !== $deal)
        @include('redesign.auth.pieces.landing_agent_shares_deal')
    @endif
@endsection

@section('form')
    <h3 class="headline centered margin-bottom-45">
        <strong class="headline-with-separator">Registrieren</strong>
    </h3>

    @include('redesign.auth.pieces.register_form')
@endsection