@extends('redesign.layouts.listeo.auth')

@section('title', 'Zwei-Faktor-Authentisierung')

@section('form')
    <h3 class="headline centered margin-bottom-45">
        <strong class="headline-with-separator">Zwei-Faktor-Authentisierung</strong>
    </h3>

    <div class="text-center">
        @if( $user->google_tfa_secret )
            Öffne Deine Authentifizierungs-App und gib den Code für RECOMA ein.
        @else
            Wir haben Dir eine E-Mail mit dem Zwei-Faktor-Authentifizierungscode gesendet.
        @endif
        <br/>
        <br/>
    </div>

    <form id="tfaForm" action="{{ route('tfa.verify') }}" method="post">
        {{ csrf_field() }}

        <p class="form-row form-row-wide">
            <label for="tfaCode">
                <i class="im im-icon-Lock"></i>
                <input type="text" class="input-text {{ $errors->has('token') ? ' has-error' : '' }}" name="token" id="tfaCode" placeholder="Code eingeben" value="">
            </label>
            @include('redesign.pieces.form.error', ['property' => 'token'])
        </p>

        <div class="text-center margin-top-30">
            <input type="submit" class="button border margin-top-5" name="verify" value="Verifizieren">
        </div>
    </form>
@endsection