@extends('redesign.layouts.listeo.auth')

@section('title', 'Unternehmen registrieren')

@section('meta')
    <meta property="og:url" content="{{ Request::fullUrl() }}" />
    <meta property="og:type" content="website" />
    <meta property="fb:app_id" content="{{ config('services.facebook.app_id') }}" />

    <meta property="og:image" content="{{ $meta->image }}" />
    <meta property="og:image:width" content="200" />
    <meta property="og:image:height" content="200" />
    <meta property="og:title" content="{{ $meta->title }}" />
    <meta property="og:description" content="{{ $meta->descr }}" />
@endsection

@section('form')
    <h3 class="headline centered margin-bottom-45">
        <strong class="headline-with-separator">Unternehmen registrieren</strong>
    </h3>

    <form id="registerForm" action="{{ route('seller.register') }}" method="post">
        {{ csrf_field() }}

        @if (null !== $referrer)
            <input type="hidden" id="referrer" name="invited_by" value="{{ $referrer->id }}">
        @endif

        <input type="hidden" name="form" value="auth_seller_registration">

        <div class="form-row form-row-wide inputHolder">
            <label for="registerEmail">
                <i class="im im-icon-Mail"></i>
                <input type="text" class="emailInput input-text {{ $errors->has('email') ? ' has-error' : '' }}" name="email" id="registerEmail" placeholder="Ihre E-Mail Adresse" value="{{ old('email') }}" data-err="#registerEmailErr">
            </label>
            <p class="text-danger text-center error-message" style="display: none" id="registerEmailErr"></p>
            @include('redesign.pieces.form.error', ['property' => 'email'])
        </div>

        <div class="form-row form-row-wide inputHolder">
            <label for="registerPassword">
                <i class="im im-icon-Lock-2"></i>
                <input class="passwordInput input-text {{ $errors->has('password') ? ' has-error' : '' }}" type="password" name="password" placeholder="Ihr Passwort" id="registerPassword" data-min="10" data-strength="2" data-err="#registerPasswordErr">
                <span class="passwordVisibilityToggler"><i class="im im-icon-Eye-Visible"></i></span>
                @include('redesign.auth.pieces.password_hint')
            </label>
            <p class="text-danger text-center error-message" style="display: none" id="registerPasswordErr"></p>
            @include('redesign.pieces.form.error', ['property' => 'password'])
        </div>

        <div class="text-small inputHolder">
            <div class="checkboxes margin-bottom-15">
                <input class="agbInput" id="registerAGB" type="checkbox" name="agb" value="1" data-err="#registerAGBErr">
                <label for="registerAGB">Ich habe die <a target="_blank" class="text-primary" href="{{ route('agb') }}">Allgemeinen Geschäftsbedingungen</a> und die <a target="_blank" class="text-primary" href="{{ route('privacy') }}">Datenschutzerklärung</a> gelesen und akzeptiere diese.</label>
                <p class="text-danger text-center error-message" style="display: none" id="registerAGBErr"></p>
                @include('redesign.pieces.form.error', ['property' => 'agb'])
            </div>
        </div>

        <div class="text-small">
            <div class="checkboxes margin-bottom-15">
                <input id="registerNewsletter" type="checkbox" name="newsletter" value="1">
                <label for="registerNewsletter">Ich möchte personalisierte E-Mails mit wertvollen Tipps und Hinweisen erhalten.</label>
            </div>
        </div>

        <input type="text" name="sectoken" value="{{ csrf_token() }}" style="display: none">

        <div class="text-center">
            <input type="submit" class="formValidate button border margin-top-5" name="login" value="Registrieren">
        </div>
    </form>
@endsection