<form id="registerForm" action="{{ route('user.register') }}" method="post">
    {{ csrf_field() }}

    @if (null !== $referrer)
        <input type="hidden" id="referrer" name="referred_by" value="{{ $referrer->id }}">
    @endif

    <div class="form-row form-row-wide inputHolder">
        <label for="registerEmail">
            <i class="im im-icon-Mail"></i>
            <input type="text" class="emailInput input-text {{ $errors->has('email') ? ' has-error' : '' }}" name="email" id="registerEmail" placeholder="Deine E-Mail Adresse" value="{{ old('email') }}" data-err="#registerEmailErr">
        </label>
        <p class="text-danger text-center error-message" style="display: none" id="registerEmailErr"></p>
        @include('redesign.pieces.form.error', ['property' => 'email'])
    </div>

    <div class="form-row form-row-wide inputHolder">
        <label for="registerPassword">
            <i class="im im-icon-Lock-2"></i>
            <input class="passwordInput input-text {{ $errors->has('password') ? ' has-error' : '' }}" type="password" name="password" placeholder="Dein Passwort" id="registerPassword" data-min="10" data-strength="2" data-err="#registerPasswordErr">
            <span class="passwordVisibilityToggler"><i class="im im-icon-Eye-Visible"></i></span>
            @include('redesign.auth.pieces.password_hint')
        </label>
        <p class="text-danger text-center error-message" style="display: none" id="registerPasswordErr"></p>
        @include('redesign.pieces.form.error', ['property' => 'password'])
    </div>

    <div class="text-small inputHolder">
        <div class="checkboxes margin-bottom-15">
            <input class="agbInput" id="registerAGB" type="checkbox" name="agb" value="1" data-err="#registerAGBErr">
            <label for="registerAGB">Ich habe die <a target="_blank" class="text-primary" href="{{ route('agb') }}">Allgemeinen Geschäftsbedingungen</a> und die <a target="_blank" class="text-primary" href="{{ route('privacy') }}">Datenschutzerklärung</a> gelesen und akzeptiere diese.</label>
            <p class="text-danger text-center error-message" style="display: none" id="registerAGBErr"></p>
            @include('redesign.pieces.form.error', ['property' => 'agb'])
        </div>
    </div>

    <div class="text-small">
        <div class="checkboxes margin-bottom-15">
            <input id="registerNewsletter" type="checkbox" name="newsletter" value="1">
            <label for="registerNewsletter">Ich möchte personalisierte E-Mails mit tollen Deals von RECO.MA erhalten.</label>
        </div>
    </div>

    <div class="text-center">
        <input type="submit" class="formValidate button border margin-top-5" name="login" value="Registrieren">
    </div>

    <div class="text-small text-center">
        <br>
        Verwendest Du bereits RECO.MA? <a href="{{ url('/login') }}" class="text-primary">Hier anmelden</a>
    </div>
</form>