@extends('redesign.layouts.listeo.auth')

@section('title', 'Passwort vergessen')

@section('form')
    <h3 class="headline centered margin-bottom-45">
        <strong class="headline-with-separator">Neues Passwort eingeben</strong>
    </h3>

    <div class="text-center">
        Bitte gib Deine E-Mail-Adresse und Dein neues Passwort ein.
    </div>

    <form id="resetForm" action="{{ url('/password/reset') }}" method="post">
        {{ csrf_field() }}

        <input type="hidden" name="token" value="{{ $token }}">

        <input type="hidden" name="form" value="auth_reset">

        <div class="form-row form-row-wide inputHolder">
            <label for="resetEmail">
                <i class="im im-icon-Mail"></i>
                <input class="emailInput input-text {{ $errors->has('email') ? ' has-error' : '' }}" type="text" name="email" placeholder="Deine E-Mail Adresse" id="resetEmail" value="{{ old('email') }}" data-err="#resetEmailErr">
            </label>
            <p class="text-danger text-center error-message" style="display: none" id="resetEmailErr"></p>
            @include('redesign.pieces.form.error', ['property' => 'email'])
        </div>

        <div class="form-row form-row-wide inputHolder">
            <label for="resetPassword">
                <i class="im im-icon-Lock-2"></i>
                <input class="passwordInput input-text {{ $errors->has('password') ? ' has-error' : '' }}" type="password" name="password" placeholder="Passwort" id="resetPassword" data-min="10" data-strength="2" data-err="#resetPasswordErr">
                <span class="passwordVisibilityToggler"><i class="im im-icon-Eye-Visible"></i></span>
                @include('redesign.auth.pieces.password_hint')
            </label>
            <p class="text-danger text-center error-message" style="display: none" id="resetPasswordErr"></p>
            @include('redesign.pieces.form.error', ['property' => 'password'])
        </div>

        <div class="form-row form-row-wide inputHolder">
            <label for="resetPasswordConfirm">
                <i class="im im-icon-Lock-2"></i>
                <input class="passwordConfirmInput input-text {{ $errors->has('password_confirmation') ? ' has-error' : '' }}" type="password" name="password_confirmation" placeholder="Passwort bestätigen" id="resetPasswordConfirm" data-err="#resetPasswordConfirmErr">
                <span class="passwordVisibilityToggler"><i class="im im-icon-Eye-Visible"></i></span>
            </label>
            <p class="text-danger text-center error-message" style="display: none" id="resetPasswordConfirmErr"></p>
            @include('redesign.pieces.form.error', ['property' => 'password_confirmation'])
        </div>

        <div class="text-center">
            <input type="submit" class="formValidate button border margin-top-5" name="login" value="Passwort ändern">
        </div>
    </form>
@endsection