@extends('redesign.layouts.listeo.auth')

@section('title', 'Passwort vergessen')

@section('form')
    <h3 class="headline centered margin-bottom-45">
        <strong class="headline-with-separator">Passwort vergessen</strong>
    </h3>

    <div class="text-center">
        Bitte gib hier Deine E-Mail Adresse ein. Wir schicken Dir im Anschluss eine E-Mail mit einem Link, damit Du dein Passwort zurücksetzen kannst.
        <br/>
        <br/>
    </div>

    <form id="recoveryForm" action="{{ url('/password/email') }}" method="post">
        {{ csrf_field() }}

        <input type="hidden" name="form" value="auth_recovery">

        <p class="form-row form-row-wide">
            <label for="recoveryEmail">
                <i class="im im-icon-Mail"></i>
                <input type="text" class="input-text {{ $errors->has('email') ? ' has-error' : '' }}" name="email" id="recoveryEmail" placeholder="E-Mail Adresse" value="{{ old('email') }}">
            </label>
            @include('redesign.pieces.form.error', ['property' => 'email'])
        </p>

        <div class="text-center margin-top-30">
            <input type="submit" class="button border margin-top-5" name="login" value="Passwort anfordern">
        </div>
    </form>
@endsection