@extends('redesign.layouts.listeo.auth')

@section('title', 'Login')

@section('meta')
    @include('redesign.front.pieces.meta.common')
@endsection

@section('form')
    <h3 class="headline centered margin-bottom-45">
        <strong class="headline-with-separator">Login</strong>
    </h3>

    <form id="loginForm" action="{{ url('login') }}" method="post">
        {{ csrf_field() }}

        <input id="token" name="token" type="hidden" value="{{ $token ?? -1 }}">

        <input type="hidden" name="form" value="auth_login">

        <p class="form-row form-row-wide">
            <label for="loginEmail">
                <i class="im im-icon-Mail"></i>
                <input type="text" class="input-text {{ $errors->has('email') ? ' has-error' : '' }}" name="email" id="loginEmail" placeholder="E-Mail Adresse" value="{{ old('email') }}">
            </label>
            @include('redesign.pieces.form.error', ['property' => 'email'])
        </p>

        <p class="form-row form-row-wide">
            <label for="loginPassword">
                <i class="im im-icon-Lock-2"></i>
                <input class="input-text {{ $errors->has('password') ? ' has-error' : '' }}" type="password" name="password" placeholder="Passwort" id="loginPassword">
                <span class="passwordVisibilityToggler"><i class="im im-icon-Eye-Visible"></i></span>
            </label>
            @include('redesign.pieces.form.error', ['property' => 'password'])
        </p>

        <div class="text-center">
            <input type="submit" class="button border margin-top-5" name="login" value="Anmelden">
        </div>

        @if ( config('recoma.openedSystem', false) || session('seller_id') )
            <div class="text-center">
                <br>
                Bist Du neuer Kunde? <a href="{{ url('/registration') }}" class="text-primary">Hier registrieren</a>
            </div>
        @endif

        <div class="text-center">
            <br>
            <a class="fs-12" href="{{ url('password/reset') }}">Passwort vergessen?</a>
        </div>
    </form>
@endsection