@extends('redesign.layouts.listeo.auth')

@section('title', 'Miarbeiter registrieren')

@section('meta')
    @include('redesign.front.pieces.meta.common')
@endsection

@section('form')
    <h3 class="headline centered margin-bottom-45">
        <strong class="headline-with-separator">Miarbeiter registrieren</strong>
    </h3>

    <form id="registerForm" action="{{ route('employee.register', $employee->id) }}" method="post">
        {{ csrf_field() }}

        <input type="hidden" name="form" value="auth_employee_registration">

        <div class="form-row form-row-wide inputHolder">
            <label for="registerEmail">
                <i class="im im-icon-Mail"></i>
                <input type="text" class="input-text {{ $errors->has('email') ? ' has-error' : '' }}" name="email" id="registerEmail" placeholder="Ihre E-Mail Adresse" value="{{ $employee->email }}" disabled readonly>
            </label>
            @include('redesign.pieces.form.error', ['property' => 'email'])
        </div>

        <div class="form-row form-row-wide inputHolder">
            <label for="registerPassword">
                <i class="im im-icon-Lock-2"></i>
                <input class="passwordInput input-text {{ $errors->has('password') ? ' has-error' : '' }}" type="password" name="password" placeholder="Dein Passwort" id="registerPassword" data-min="10" data-strength="2" data-err="#registerPasswordErr">
                <span class="passwordVisibilityToggler"><i class="im im-icon-Eye-Visible"></i></span>
                @include('redesign.auth.pieces.password_hint')
            </label>
            <p class="text-danger text-center error-message" style="display: none" id="registerPasswordErr"></p>
            @include('redesign.pieces.form.error', ['property' => 'password'])
        </div>

        <div class="text-small inputHolder">
            <div class="checkboxes margin-bottom-15">
                <input class="agbInput" id="registerAGB" type="checkbox" name="agb" value="1">
                <label for="registerAGB">Ich habe die <a target="_blank" class="text-primary" href="{{ route('agb') }}">Allgemeinen Geschäftsbedingungen</a> und die <a target="_blank" class="text-primary" href="{{ route('privacy') }}">Datenschutzerklärung</a> gelesen und akzeptiere diese.</label>
                @include('redesign.pieces.form.error', ['property' => 'agb'])
            </div>
        </div>

        <input type="hidden" name="token" value="{{ $token }}" />

        <div class="text-center">
            <input type="submit" class="formValidate button border margin-top-5" name="login" value="Registrierung abschließen">
        </div>
    </form>
@endsection