@extends('layouts.home')

@section('title', 'Einladungen')

@section('content')

    <div class="row">
        <div class="col col-lg-12 col-md-12 col-xs-12 text-center"> {{-- to un-flex --}}
            <div class="ibox float-e-margins" id="recommend-recoma">

                @if(request()->route()->getName() === "recommendRecoma")
                    @include('vendor.components.recommend-recoma.header')
                    <div class="ibox-content">
                        <div class="recommend-text-wrapper well no-borders"
                             style="margin: 0 -15px 15px; border-radius: 0">
                            @include('vendor.components.recommend-recoma.body')
                        </div>

                        @include('vendor.components.recommend-recoma.footer')
                        @endif

                        @if(request()->route()->getName() === "recommendAgent")
                            @include('vendor.components.recommend-agent.header')
                            <div class="ibox-content">
                                <div class="recommend-text-wrapper well no-borders"
                                     style="margin: 0 -15px 15px; border-radius: 0">
                                    @include('vendor.components.recommend-agent.body')
                                </div>

                                @include('vendor.components.recommend-agent.footer')
                                @endif

                                <div class="row text-center">
                                    <div class="col-lg-6 col-lg-offset-3 custom-button-group">
                                        @include('vendor.components.buttongroup',$buttons)
                                    </div>
                                </div>

                                @if(isset($buttons[3]))
                                <div class="row text-center">
                                    <div class="col-lg-6 col-lg-offset-3 custom-button-group">
                                        <div class="col-xs-push-4 col-xs-4">
                                            <a class="btn btn-primary block"
                                               href="{{ $buttons[3]['url'] }}"
                                               @if(isset($buttons[3]['target']))target="_blank" @endif data-href="">
                                                {{ $buttons[3]['name'] }}
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                @endif
                            </div>

                    </div>
                    @if(isset($grid))
                        <div class="ibox float-e-margins">
                            <div class="ibox-title">
                                <h5>Meine RECO.MA Empfehlungen</h5>
                            </div>
                            <div class="ibox-content">
                                {!! $grid->__toString() !!}
                            </div>
                        </div>
                    @endif
            </div>
@endsection

