@extends('layouts.home')

@section('title', 'Einladungen')

@section('content')
    <div class="row">
        <div class="col col-lg-6 col-md-12 col-xs-12 text-center"> {{-- to un-flex --}}
            <div class="ibox float-e-margins" id="recommend-recoma">
                <div class="ibox-title">
                    <h5>Empfehle das Unternehmen</h5>
                </div>
                <div class="ibox-content text-center">
                    <img style="width:20%; margin: 0 auto" class="img-responsive"
                         src="/account/portraits/{{$account->upload_portrait}}"
                         alt="{{$account->company}} Logo">
                    <hr>

                    <p class="text-danger"><strong>Erhalte {!! $account->getSellerMaxRecoCash() !!}
                            %
                            RECO.CASH für Deine
                            Empfehlung</strong></p>
                    <p><b>von {{$account->company}}</b></p>
                    <div class="recommend-text-wrapper well no-borders"
                         style="margin: 0 -15px 15px; border-radius: 0px">
                        <strong>So erhälst Du das RECO.CASH</strong>
                        <p>
                            Sende eine Empfehlung an deine Freunde per Whatsapp, E-Mail oder SMS. Folgen deine
                            Freunde der
                            Empfehlung und lösen den RECO.BON ein,
                            schreiben wir Dir automatisch das RECO.CASH gut. DU kannst es dir jederzeit auf Dein
                            Konto
                            auszahlen.
                        </p>
                    </div>
                    <p>
                        <b>Jetzt {!! $account->company !!} empfehlen</b>
                    </p>
                    <div class="row custom-button-group">
                        <div class="col-md-4 col-sm-4 col-xs-4">

                            <a class="btn btn-success block"
                               href="{{ $buttons[0]['url'] }}"
                               @if(isset($buttons[0]['target']))target="_blank" @endif data-href="">
                                {{ $buttons[0]['name'] }}
                            </a>
                        </div>
                        <div class="col-md-4 col-sm-4 col-xs-4">
                            <a class="btn btn-primary block"
                               href="{{ $buttons[1]['url'] }}"
                               @if(isset($buttons[1]['target']))target="_blank" @endif data-href="">
                                {{ $buttons[1]['name'] }}
                            </a>
                        </div>
                        <div class="col-md-4 col-sm-4 col-xs-4">
                            <a class="btn btn-warning block"
                               href="{{ $buttons[2]['url'] }}"
                               @if(isset($buttons[2]['target']))target="_blank" @endif data-href="">
                                {{ $buttons[2]['name'] }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col col-lg-6 col-md-12 col-xs-12 text-center">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Vorschau</h5>
                </div>
                <div class="ibox-content">
                    <div class="coupon-without-button">
                        @if(isset($couponTemplate) && $couponTemplate instanceof \App\CouponTemplate)
                            @include('partials/coupon', [
                               'template' => $couponTemplate,
                               'agent' => Auth::user(),
                               'usePreviewMarker' => true

                           ])
                        @else
                            @include('partials/coupon', [
                                'seller' => $account,
                                'agent' => Auth::user(),
                                'usePreviewMarker' => true
                                ])
                        @endif
                    </div>
                </div>
            </div>
        </div>

    </div>

    @if(isset($grid))
        <div class="ibox float-e-margins">
            <div class="ibox-title">
                <h5>Meine Empfehlungen</h5>
            </div>
            <div class="ibox-content">
                {!! $grid->__toString() !!}
            </div>
        </div>
    @endif

@endsection

