@extends('layouts.home')

@section('title', 'Einladungen')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>{{ $headline }}</h5>
                </div>
                <div class="ibox-content">
                    <form class="form-horizontal" role="form" method="POST" action="{{ url($action) }}" enctype="multipart/form-data">
                        {{ csrf_field() }}

                        <input type="hidden" name="tokenId" value="{{$tokenId}}">

                        <div class="form-group{{ $errors->has('salutation') ? ' has-error' : '' }}">
                            <label for="salutation" class="col-sm-2 control-label">Anrede</label>

                            <div class="col-sm-10">
                                <select name="salutation" size="1" id="salutation" class="form-control">
                                    <option value="">Bitte Anrede auswählen*</option>
                                    <option value="Herr"{{ (Input::old("salutation") == 'Herr' ? " selected":"") }}>Herr
                                    </option>
                                    <option value="Frau"{{ (Input::old("salutation") == 'Frau' ? " selected":"") }}>Frau
                                    </option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('firstname') ? ' has-error' : '' }}">
                            <label for="firstname" class="col-sm-2 control-label">Vorname</label>

                            <div class="col-sm-10">
                                <input id="firstname" type="text" class="form-control" name="firstname"
                                       value="{{ old('firstname') }}">

                                @if ($errors->has('firstname'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('firstname') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('surname') ? ' has-error' : '' }}">
                            <label for="surname" class="col-sm-2 control-label">Nachname</label>

                            <div class="col-sm-10">
                                <input id="surname" type="text" class="form-control" name="surname"
                                       value="{{ old('surname') }}">

                                @if ($errors->has('surname'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('surname') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        @if($type === 'sms')
                            @if(!Auth::user()->mobile_verified && !Auth::user()->hasRole('seller'))
                                <div class="col-sm-10 col-sm-offset-2 alert alert-warning">
                                    <h3>Ihre Handynummer {{ Auth::user()->mobile }} ist noch nicht verifiziert.</h3>

                                    <a href="/user/profile#mobile" class="btn btn-warning">
                                        Zur Verifizierung
                                    </a>
                                </div>
                            @endif
                            <div class="form-group{{ $errors->has('mobile') ? ' has-error' : '' }}">
                                <label class="col-sm-2 control-label" for="mobile">Handynummer*</label>

                                <div class="col-sm-10">
                                    <input id="mobile" type="text" class="form-control fill-in" name="mobile"
                                           value="{{ old('mobile') }}"
                                           placeholder="">

                                    @if ($errors->has('mobile'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('mobile') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>


                            <div class="form-group{{ $errors->has('smsText') ? ' has-error' : '' }} sms-text-group">
                                <label class="col-sm-2 control-label" for="smsText">SMS-Nachricht</label>

                                <div class="col-sm-10">
                                    <div class="preview">
                                        <input id="messagetext" class="form-control" name="smsText"
                                               value="{{ old('smsText') }}">
                                    </div>
                                    @if ($errors->has('smsText'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('smsText') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        @else

                            <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                                <label class="col-sm-2 control-label" for="email">E-Mail*</label>

                                <div class="col-sm-10">
                                    <input id="email" type="email" class="form-control fill-in" name="email"
                                           value="{{ old('email') }}"
                                           placeholder="">

                                    @if ($errors->has('email'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('email') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="clear"></div>

                        @endif

                        <div class="form-group">
                            <div class="col-sm-10 col-sm-offset-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-btn fa-user"></i> Empfehlen
                                </button>

                                <a class="btn btn-primary" href="{{ url('/recommend-recoma') }}">Zurück</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

