<form class="form-horizontal" method="post" action="{{ $action }}" enctype="multipart/form-data">
    {{ csrf_field() }}
    @if ( isset($usersGift) && $usersGift->id )
        {{ method_field('PUT') }}
    @endif

    <div class="form-group{{ $errors->has('address_plz') ? ' has-error' : '' }}">
        <label class="col-sm-2 control-label" for="address_plz">PLZ</label>
        <div class="col-sm-10">
            <input id="address_plz" type="text" class="form-control" name="address_plz" value="{{ old('address_plz', (isset($usersGift) && $usersGift->address_plz) ? $usersGift->address_plz : $user->account->zip) }}" placeholder="PLZ">

            @include('partials.form.error', ['property' => 'address_plz'])
        </div>
    </div>

    <div class="form-group{{ $errors->has('address_ort') ? ' has-error' : '' }}">
        <label class="col-sm-2 control-label" for="address_ort">Ort</label>
        <div class="col-sm-10">
            <input id="address_ort" type="text" class="form-control" name="address_ort" value="{{ old('address_ort', (isset($usersGift) && $usersGift->address_ort) ? $usersGift->address_ort : $user->account->city) }}" placeholder="Ort">

            @include('partials.form.error', ['property' => 'address_ort'])
        </div>
    </div>

    <div class="form-group{{ $errors->has('address_str') ? ' has-error' : '' }}">
        <label class="col-sm-2 control-label" for="address_str">Straße</label>
        <div class="col-sm-10">
            <input id="address_str" type="text" class="form-control" name="address_str" value="{{ old('address_str', (isset($usersGift) && $usersGift->address_str) ? $usersGift->address_str : $user->account->street) }}" placeholder="Straße">

            @include('partials.form.error', ['property' => 'address_str'])
        </div>
    </div>

    <div class="form-group{{ $errors->has('address_num') ? ' has-error' : '' }}">
        <label class="col-sm-2 control-label" for="address_num">Hausnummer</label>
        <div class="col-sm-10">
            <input id="address_num" type="text" class="form-control" name="address_num" value="{{ old('address_num', (isset($usersGift) && $usersGift->address_num) ? $usersGift->address_num : $user->account->housenumber) }}" placeholder="Hausnummer">

            @include('partials.form.error', ['property' => 'address_num'])
        </div>
    </div>

    <div class="form-group{{ $errors->has('address_add') ? ' has-error' : '' }}">
        <label class="col-sm-2 control-label" for="address_add">Zusätzliche Information</label>
        <div class="col-sm-10">
            <input id="address_add" type="text" class="form-control" name="address_add" value="{{ old('address_add', isset($usersGift) ? $usersGift->address_add : '') }}" placeholder="">

            @include('partials.form.error', ['property' => 'address_add'])
        </div>
    </div>

    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-10">
            <button type="submit" class="btn btn-primary">
                <i class="fa fa-save"></i> Speichern
            </button>
            <a href="{{ route('owngift-list') }}" class="btn btn-default">
                <i class="fa fa-close"></i> Abbrechen
            </a>
        </div>
    </div>
</form>